package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.Short;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxmNxNsiBuilder} instances.
 *
 * @see NxmNxNsiBuilder
 *
 */
public class NxmNxNsiBuilder implements Builder<NxmNxNsi> {

    private Short _nsi;


    Map<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> augmentation = Collections.emptyMap();

    public NxmNxNsiBuilder() {
    }

    public NxmNxNsiBuilder(NxmNxNsi base) {
        this._nsi = base.getNsi();
        if (base instanceof NxmNxNsiImpl) {
            NxmNxNsiImpl impl = (NxmNxNsiImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> aug =((AugmentationHolder<NxmNxNsi>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }


    public Short getNsi() {
        return _nsi;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxmNxNsi>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    private static void checkNsiRange(final short value) {
        if (value >= (short)0 && value <= (short)255) {
            return;
        }
        CodeHelpers.throwInvalidRange("[[0..255]]", value);
    }
    
    public NxmNxNsiBuilder setNsi(final Short value) {
    if (value != null) {
        checkNsiRange(value);
        
    }
        this._nsi = value;
        return this;
    }
    
    public NxmNxNsiBuilder addAugmentation(Class<? extends Augmentation<NxmNxNsi>> augmentationType, Augmentation<NxmNxNsi> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxmNxNsiBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNsi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxmNxNsi build() {
        return new NxmNxNsiImpl(this);
    }

    private static final class NxmNxNsiImpl implements NxmNxNsi {
    
        private final Short _nsi;
    
        private Map<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> augmentation = Collections.emptyMap();
    
        NxmNxNsiImpl(NxmNxNsiBuilder base) {
            this._nsi = base.getNsi();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxmNxNsi> getImplementedInterface() {
            return NxmNxNsi.class;
        }
    
        @Override
        public Short getNsi() {
            return _nsi;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxmNxNsi>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nsi);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNsi.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNsi other = (NxmNxNsi)obj;
            if (!Objects.equals(_nsi, other.getNsi())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxmNxNsiImpl otherImpl = (NxmNxNsiImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxNsi");
            CodeHelpers.appendValue(helper, "_nsi", _nsi);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
