package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.group.input.updated.group.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder} instances.
 *
 * @see NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder
 *
 */
public class NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder implements Builder<NxActionResubmitRpcUpdateGroupUpdatedCase> {

    private NxResubmit _nxResubmit;


    Map<Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();

    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder() {
    }
    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping arg) {
        this._nxResubmit = arg.getNxResubmit();
    }

    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder(NxActionResubmitRpcUpdateGroupUpdatedCase base) {
        this._nxResubmit = base.getNxResubmit();
        if (base instanceof NxActionResubmitRpcUpdateGroupUpdatedCaseImpl) {
            NxActionResubmitRpcUpdateGroupUpdatedCaseImpl impl = (NxActionResubmitRpcUpdateGroupUpdatedCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> aug =((AugmentationHolder<NxActionResubmitRpcUpdateGroupUpdatedCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping) {
            this._nxResubmit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping)arg).getNxResubmit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping]");
    }

    public NxResubmit getNxResubmit() {
        return _nxResubmit;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder setNxResubmit(final NxResubmit value) {
        this._nxResubmit = value;
        return this;
    }
    
    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> augmentationType, Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionResubmitRpcUpdateGroupUpdatedCase build() {
        return new NxActionResubmitRpcUpdateGroupUpdatedCaseImpl(this);
    }

    private static final class NxActionResubmitRpcUpdateGroupUpdatedCaseImpl implements NxActionResubmitRpcUpdateGroupUpdatedCase {
    
        private final NxResubmit _nxResubmit;
    
        private Map<Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> augmentation = Collections.emptyMap();
    
        NxActionResubmitRpcUpdateGroupUpdatedCaseImpl(NxActionResubmitRpcUpdateGroupUpdatedCaseBuilder base) {
            this._nxResubmit = base.getNxResubmit();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionResubmitRpcUpdateGroupUpdatedCase> getImplementedInterface() {
            return NxActionResubmitRpcUpdateGroupUpdatedCase.class;
        }
    
        @Override
        public NxResubmit getNxResubmit() {
            return _nxResubmit;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxResubmit);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionResubmitRpcUpdateGroupUpdatedCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionResubmitRpcUpdateGroupUpdatedCase other = (NxActionResubmitRpcUpdateGroupUpdatedCase)obj;
            if (!Objects.equals(_nxResubmit, other.getNxResubmit())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionResubmitRpcUpdateGroupUpdatedCaseImpl otherImpl = (NxActionResubmitRpcUpdateGroupUpdatedCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>>, Augmentation<NxActionResubmitRpcUpdateGroupUpdatedCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionResubmitRpcUpdateGroupUpdatedCase");
            CodeHelpers.appendValue(helper, "_nxResubmit", _nxResubmit);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
