package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxIpv6SrcCaseBuilder} instances.
 *
 * @see SrcNxIpv6SrcCaseBuilder
 *
 */
public class SrcNxIpv6SrcCaseBuilder implements Builder<SrcNxIpv6SrcCase> {

    private Boolean _nxIpv6Src;


    Map<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> augmentation = Collections.emptyMap();

    public SrcNxIpv6SrcCaseBuilder() {
    }
    public SrcNxIpv6SrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping arg) {
        this._nxIpv6Src = arg.isNxIpv6Src();
    }

    public SrcNxIpv6SrcCaseBuilder(SrcNxIpv6SrcCase base) {
        this._nxIpv6Src = base.isNxIpv6Src();
        if (base instanceof SrcNxIpv6SrcCaseImpl) {
            SrcNxIpv6SrcCaseImpl impl = (SrcNxIpv6SrcCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> aug =((AugmentationHolder<SrcNxIpv6SrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping) {
            this._nxIpv6Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping)arg).isNxIpv6Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6SrcGrouping]");
    }

    public Boolean isNxIpv6Src() {
        return _nxIpv6Src;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxIpv6SrcCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxIpv6SrcCaseBuilder setNxIpv6Src(final Boolean value) {
        this._nxIpv6Src = value;
        return this;
    }
    
    public SrcNxIpv6SrcCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxIpv6SrcCase>> augmentationType, Augmentation<SrcNxIpv6SrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxIpv6SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxIpv6SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxIpv6SrcCase build() {
        return new SrcNxIpv6SrcCaseImpl(this);
    }

    private static final class SrcNxIpv6SrcCaseImpl implements SrcNxIpv6SrcCase {
    
        private final Boolean _nxIpv6Src;
    
        private Map<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> augmentation = Collections.emptyMap();
    
        SrcNxIpv6SrcCaseImpl(SrcNxIpv6SrcCaseBuilder base) {
            this._nxIpv6Src = base.isNxIpv6Src();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxIpv6SrcCase> getImplementedInterface() {
            return SrcNxIpv6SrcCase.class;
        }
    
        @Override
        public Boolean isNxIpv6Src() {
            return _nxIpv6Src;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxIpv6SrcCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxIpv6Src);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxIpv6SrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxIpv6SrcCase other = (SrcNxIpv6SrcCase)obj;
            if (!Objects.equals(_nxIpv6Src, other.isNxIpv6Src())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxIpv6SrcCaseImpl otherImpl = (SrcNxIpv6SrcCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxIpv6SrcCase>>, Augmentation<SrcNxIpv6SrcCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxIpv6SrcCase");
            CodeHelpers.appendValue(helper, "_nxIpv6Src", _nxIpv6Src);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
