package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxIpv6DstCaseBuilder} instances.
 *
 * @see SrcNxIpv6DstCaseBuilder
 *
 */
public class SrcNxIpv6DstCaseBuilder implements Builder<SrcNxIpv6DstCase> {

    private Boolean _nxIpv6Dst;


    Map<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> augmentation = Collections.emptyMap();

    public SrcNxIpv6DstCaseBuilder() {
    }
    public SrcNxIpv6DstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping arg) {
        this._nxIpv6Dst = arg.isNxIpv6Dst();
    }

    public SrcNxIpv6DstCaseBuilder(SrcNxIpv6DstCase base) {
        this._nxIpv6Dst = base.isNxIpv6Dst();
        if (base instanceof SrcNxIpv6DstCaseImpl) {
            SrcNxIpv6DstCaseImpl impl = (SrcNxIpv6DstCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> aug =((AugmentationHolder<SrcNxIpv6DstCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping) {
            this._nxIpv6Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping)arg).isNxIpv6Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxIpv6DstGrouping]");
    }

    public Boolean isNxIpv6Dst() {
        return _nxIpv6Dst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxIpv6DstCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxIpv6DstCaseBuilder setNxIpv6Dst(final Boolean value) {
        this._nxIpv6Dst = value;
        return this;
    }
    
    public SrcNxIpv6DstCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxIpv6DstCase>> augmentationType, Augmentation<SrcNxIpv6DstCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxIpv6DstCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxIpv6DstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxIpv6DstCase build() {
        return new SrcNxIpv6DstCaseImpl(this);
    }

    private static final class SrcNxIpv6DstCaseImpl implements SrcNxIpv6DstCase {
    
        private final Boolean _nxIpv6Dst;
    
        private Map<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> augmentation = Collections.emptyMap();
    
        SrcNxIpv6DstCaseImpl(SrcNxIpv6DstCaseBuilder base) {
            this._nxIpv6Dst = base.isNxIpv6Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxIpv6DstCase> getImplementedInterface() {
            return SrcNxIpv6DstCase.class;
        }
    
        @Override
        public Boolean isNxIpv6Dst() {
            return _nxIpv6Dst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxIpv6DstCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxIpv6Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxIpv6DstCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxIpv6DstCase other = (SrcNxIpv6DstCase)obj;
            if (!Objects.equals(_nxIpv6Dst, other.isNxIpv6Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxIpv6DstCaseImpl otherImpl = (SrcNxIpv6DstCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxIpv6DstCase>>, Augmentation<SrcNxIpv6DstCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxIpv6DstCase");
            CodeHelpers.appendValue(helper, "_nxIpv6Dst", _nxIpv6Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
