package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder} instances.
 *
 * @see NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder
 *
 */
public class NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder implements Builder<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase> {

    private NxConntrack _nxConntrack;


    Map<Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder() {
    }
    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping arg) {
        this._nxConntrack = arg.getNxConntrack();
    }

    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder(NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase base) {
        this._nxConntrack = base.getNxConntrack();
        if (base instanceof NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl) {
            NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl impl = (NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> aug =((AugmentationHolder<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping) {
            this._nxConntrack = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping)arg).getNxConntrack();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping]");
    }

    public NxConntrack getNxConntrack() {
        return _nxConntrack;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder setNxConntrack(final NxConntrack value) {
        this._nxConntrack = value;
        return this;
    }
    
    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> augmentationType, Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase build() {
        return new NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl(this);
    }

    private static final class NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl implements NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase {
    
        private final NxConntrack _nxConntrack;
    
        private Map<Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> augmentation = Collections.emptyMap();
    
        NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl(NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseBuilder base) {
            this._nxConntrack = base.getNxConntrack();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase> getImplementedInterface() {
            return NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase.class;
        }
    
        @Override
        public NxConntrack getNxConntrack() {
            return _nxConntrack;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxConntrack);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase other = (NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase)obj;
            if (!Objects.equals(_nxConntrack, other.getNxConntrack())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl otherImpl = (NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>>, Augmentation<NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionConntrackNotifFlowsStatisticsUpdateWriteActionsCase");
            CodeHelpers.appendValue(helper, "_nxConntrack", _nxConntrack);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
