package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxTunIpv4SrcCaseBuilder} instances.
 *
 * @see DstNxTunIpv4SrcCaseBuilder
 *
 */
public class DstNxTunIpv4SrcCaseBuilder implements Builder<DstNxTunIpv4SrcCase> {

    private Boolean _nxTunIpv4Src;


    Map<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> augmentation = Collections.emptyMap();

    public DstNxTunIpv4SrcCaseBuilder() {
    }
    public DstNxTunIpv4SrcCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping arg) {
        this._nxTunIpv4Src = arg.isNxTunIpv4Src();
    }

    public DstNxTunIpv4SrcCaseBuilder(DstNxTunIpv4SrcCase base) {
        this._nxTunIpv4Src = base.isNxTunIpv4Src();
        if (base instanceof DstNxTunIpv4SrcCaseImpl) {
            DstNxTunIpv4SrcCaseImpl impl = (DstNxTunIpv4SrcCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> aug =((AugmentationHolder<DstNxTunIpv4SrcCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping) {
            this._nxTunIpv4Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping)arg).isNxTunIpv4Src();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4SrcGrouping]");
    }

    public Boolean isNxTunIpv4Src() {
        return _nxTunIpv4Src;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstNxTunIpv4SrcCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxTunIpv4SrcCaseBuilder setNxTunIpv4Src(final Boolean value) {
        this._nxTunIpv4Src = value;
        return this;
    }
    
    public DstNxTunIpv4SrcCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxTunIpv4SrcCase>> augmentationType, Augmentation<DstNxTunIpv4SrcCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxTunIpv4SrcCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxTunIpv4SrcCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxTunIpv4SrcCase build() {
        return new DstNxTunIpv4SrcCaseImpl(this);
    }

    private static final class DstNxTunIpv4SrcCaseImpl implements DstNxTunIpv4SrcCase {
    
        private final Boolean _nxTunIpv4Src;
    
        private Map<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> augmentation = Collections.emptyMap();
    
        DstNxTunIpv4SrcCaseImpl(DstNxTunIpv4SrcCaseBuilder base) {
            this._nxTunIpv4Src = base.isNxTunIpv4Src();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstNxTunIpv4SrcCase> getImplementedInterface() {
            return DstNxTunIpv4SrcCase.class;
        }
    
        @Override
        public Boolean isNxTunIpv4Src() {
            return _nxTunIpv4Src;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstNxTunIpv4SrcCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunIpv4Src);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxTunIpv4SrcCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxTunIpv4SrcCase other = (DstNxTunIpv4SrcCase)obj;
            if (!Objects.equals(_nxTunIpv4Src, other.isNxTunIpv4Src())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxTunIpv4SrcCaseImpl otherImpl = (DstNxTunIpv4SrcCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxTunIpv4SrcCase>>, Augmentation<DstNxTunIpv4SrcCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxTunIpv4SrcCase");
            CodeHelpers.appendValue(helper, "_nxTunIpv4Src", _nxTunIpv4Src);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
