package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.add.group.input.buckets.bucket.action.action;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionResubmitRpcAddGroupCaseBuilder} instances.
 *
 * @see NxActionResubmitRpcAddGroupCaseBuilder
 *
 */
public class NxActionResubmitRpcAddGroupCaseBuilder implements Builder<NxActionResubmitRpcAddGroupCase> {

    private NxResubmit _nxResubmit;


    Map<Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>>, Augmentation<NxActionResubmitRpcAddGroupCase>> augmentation = Collections.emptyMap();

    public NxActionResubmitRpcAddGroupCaseBuilder() {
    }
    public NxActionResubmitRpcAddGroupCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping arg) {
        this._nxResubmit = arg.getNxResubmit();
    }

    public NxActionResubmitRpcAddGroupCaseBuilder(NxActionResubmitRpcAddGroupCase base) {
        this._nxResubmit = base.getNxResubmit();
        if (base instanceof NxActionResubmitRpcAddGroupCaseImpl) {
            NxActionResubmitRpcAddGroupCaseImpl impl = (NxActionResubmitRpcAddGroupCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>>, Augmentation<NxActionResubmitRpcAddGroupCase>> aug =((AugmentationHolder<NxActionResubmitRpcAddGroupCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping) {
            this._nxResubmit = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping)arg).getNxResubmit();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping]");
    }

    public NxResubmit getNxResubmit() {
        return _nxResubmit;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<NxActionResubmitRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public NxActionResubmitRpcAddGroupCaseBuilder setNxResubmit(final NxResubmit value) {
        this._nxResubmit = value;
        return this;
    }
    
    public NxActionResubmitRpcAddGroupCaseBuilder addAugmentation(Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>> augmentationType, Augmentation<NxActionResubmitRpcAddGroupCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxActionResubmitRpcAddGroupCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionResubmitRpcAddGroupCase build() {
        return new NxActionResubmitRpcAddGroupCaseImpl(this);
    }

    private static final class NxActionResubmitRpcAddGroupCaseImpl implements NxActionResubmitRpcAddGroupCase {
    
        private final NxResubmit _nxResubmit;
    
        private Map<Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>>, Augmentation<NxActionResubmitRpcAddGroupCase>> augmentation = Collections.emptyMap();
    
        NxActionResubmitRpcAddGroupCaseImpl(NxActionResubmitRpcAddGroupCaseBuilder base) {
            this._nxResubmit = base.getNxResubmit();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<NxActionResubmitRpcAddGroupCase> getImplementedInterface() {
            return NxActionResubmitRpcAddGroupCase.class;
        }
    
        @Override
        public NxResubmit getNxResubmit() {
            return _nxResubmit;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<NxActionResubmitRpcAddGroupCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxResubmit);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionResubmitRpcAddGroupCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionResubmitRpcAddGroupCase other = (NxActionResubmitRpcAddGroupCase)obj;
            if (!Objects.equals(_nxResubmit, other.getNxResubmit())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionResubmitRpcAddGroupCaseImpl otherImpl = (NxActionResubmitRpcAddGroupCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<NxActionResubmitRpcAddGroupCase>>, Augmentation<NxActionResubmitRpcAddGroupCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionResubmitRpcAddGroupCase");
            CodeHelpers.appendValue(helper, "_nxResubmit", _nxResubmit);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
