/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.op.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.op.grouping.NxmOfArpOp;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmOfArpOpBuilder
implements Builder<NxmOfArpOp> {
    private Integer _value;
    Map<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>> augmentation = Collections.emptyMap();

    public NxmOfArpOpBuilder() {
    }

    public NxmOfArpOpBuilder(NxmOfArpOp base) {
        Map aug;
        this._value = base.getValue();
        if (base instanceof NxmOfArpOpImpl) {
            NxmOfArpOpImpl impl = (NxmOfArpOpImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>>(aug);
        }
    }

    public Integer getValue() {
        return this._value;
    }

    public <E extends Augmentation<NxmOfArpOp>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkValueRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..65535]]", (Object)value);
    }

    public NxmOfArpOpBuilder setValue(Integer value) {
        if (value != null) {
            NxmOfArpOpBuilder.checkValueRange(value);
        }
        this._value = value;
        return this;
    }

    public NxmOfArpOpBuilder addAugmentation(Class<? extends Augmentation<NxmOfArpOp>> augmentationType, Augmentation<NxmOfArpOp> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmOfArpOpBuilder removeAugmentation(Class<? extends Augmentation<NxmOfArpOp>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmOfArpOp build() {
        return new NxmOfArpOpImpl(this);
    }

    private static final class NxmOfArpOpImpl
    implements NxmOfArpOp {
        private final Integer _value;
        private Map<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmOfArpOpImpl(NxmOfArpOpBuilder base) {
            this._value = base.getValue();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxmOfArpOp> getImplementedInterface() {
            return NxmOfArpOp.class;
        }

        @Override
        public Integer getValue() {
            return this._value;
        }

        public <E extends Augmentation<NxmOfArpOp>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._value);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfArpOp.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfArpOp other = (NxmOfArpOp)obj;
            if (!Objects.equals(this._value, other.getValue())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmOfArpOpImpl otherImpl = (NxmOfArpOpImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmOfArpOp>>, Augmentation<NxmOfArpOp>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmOfArpOp");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_value", (Object)this._value);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

