/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsh.flags.grouping.NxmNxNshFlags;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxNshFlagsBuilder
implements Builder<NxmNxNshFlags> {
    private Short _mask;
    private Short _nshFlags;
    Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> augmentation = Collections.emptyMap();

    public NxmNxNshFlagsBuilder() {
    }

    public NxmNxNshFlagsBuilder(NxmNxNshFlags base) {
        Map aug;
        this._mask = base.getMask();
        this._nshFlags = base.getNshFlags();
        if (base instanceof NxmNxNshFlagsImpl) {
            NxmNxNshFlagsImpl impl = (NxmNxNshFlagsImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(aug = ((AugmentationHolder)base).augmentations()).isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>>(aug);
        }
    }

    public Short getMask() {
        return this._mask;
    }

    public Short getNshFlags() {
        return this._nshFlags;
    }

    public <E extends Augmentation<NxmNxNshFlags>> E augmentation(Class<E> augmentationType) {
        return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
    }

    private static void checkMaskRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public NxmNxNshFlagsBuilder setMask(Short value) {
        if (value != null) {
            NxmNxNshFlagsBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    private static void checkNshFlagsRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        CodeHelpers.throwInvalidRange((String)"[[0..255]]", (Object)value);
    }

    public NxmNxNshFlagsBuilder setNshFlags(Short value) {
        if (value != null) {
            NxmNxNshFlagsBuilder.checkNshFlagsRange(value);
        }
        this._nshFlags = value;
        return this;
    }

    public NxmNxNshFlagsBuilder addAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType, Augmentation<NxmNxNshFlags> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmNxNshFlagsBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNshFlags>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxNshFlags build() {
        return new NxmNxNshFlagsImpl(this);
    }

    private static final class NxmNxNshFlagsImpl
    implements NxmNxNshFlags {
        private final Short _mask;
        private final Short _nshFlags;
        private Map<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        NxmNxNshFlagsImpl(NxmNxNshFlagsBuilder base) {
            this._mask = base.getMask();
            this._nshFlags = base.getNshFlags();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }

        public Class<NxmNxNshFlags> getImplementedInterface() {
            return NxmNxNshFlags.class;
        }

        @Override
        public Short getMask() {
            return this._mask;
        }

        @Override
        public Short getNshFlags() {
            return this._nshFlags;
        }

        public <E extends Augmentation<NxmNxNshFlags>> E augmentation(Class<E> augmentationType) {
            return (E)this.augmentation.get(CodeHelpers.nonNullValue(augmentationType, (String)"augmentationType"));
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._nshFlags);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNshFlags.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNshFlags other = (NxmNxNshFlags)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._nshFlags, other.getNshFlags())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxNshFlagsImpl otherImpl = (NxmNxNshFlagsImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxNshFlags>>, Augmentation<NxmNxNshFlags>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.augmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper((String)"NxmNxNshFlags");
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_mask", (Object)this._mask);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"_nshFlags", (Object)this._nshFlags);
            CodeHelpers.appendValue((MoreObjects.ToStringHelper)helper, (String)"augmentation", this.augmentation.values());
            return helper.toString();
        }
    }
}

