package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.src.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link SrcNxTunIpv4DstCaseBuilder} instances.
 *
 * @see SrcNxTunIpv4DstCaseBuilder
 *
 */
public class SrcNxTunIpv4DstCaseBuilder implements Builder<SrcNxTunIpv4DstCase> {

    private Boolean _nxTunIpv4Dst;


    Map<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> augmentation = Collections.emptyMap();

    public SrcNxTunIpv4DstCaseBuilder() {
    }
    public SrcNxTunIpv4DstCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping arg) {
        this._nxTunIpv4Dst = arg.isNxTunIpv4Dst();
    }

    public SrcNxTunIpv4DstCaseBuilder(SrcNxTunIpv4DstCase base) {
        this._nxTunIpv4Dst = base.isNxTunIpv4Dst();
        if (base instanceof SrcNxTunIpv4DstCaseImpl) {
            SrcNxTunIpv4DstCaseImpl impl = (SrcNxTunIpv4DstCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> aug =((AugmentationHolder<SrcNxTunIpv4DstCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping) {
            this._nxTunIpv4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping)arg).isNxTunIpv4Dst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxTunIpv4DstGrouping]");
    }

    public Boolean isNxTunIpv4Dst() {
        return _nxTunIpv4Dst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<SrcNxTunIpv4DstCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public SrcNxTunIpv4DstCaseBuilder setNxTunIpv4Dst(final Boolean value) {
        this._nxTunIpv4Dst = value;
        return this;
    }
    
    public SrcNxTunIpv4DstCaseBuilder addAugmentation(Class<? extends Augmentation<SrcNxTunIpv4DstCase>> augmentationType, Augmentation<SrcNxTunIpv4DstCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public SrcNxTunIpv4DstCaseBuilder removeAugmentation(Class<? extends Augmentation<SrcNxTunIpv4DstCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public SrcNxTunIpv4DstCase build() {
        return new SrcNxTunIpv4DstCaseImpl(this);
    }

    private static final class SrcNxTunIpv4DstCaseImpl implements SrcNxTunIpv4DstCase {
    
        private final Boolean _nxTunIpv4Dst;
    
        private Map<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> augmentation = Collections.emptyMap();
    
        SrcNxTunIpv4DstCaseImpl(SrcNxTunIpv4DstCaseBuilder base) {
            this._nxTunIpv4Dst = base.isNxTunIpv4Dst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<SrcNxTunIpv4DstCase> getImplementedInterface() {
            return SrcNxTunIpv4DstCase.class;
        }
    
        @Override
        public Boolean isNxTunIpv4Dst() {
            return _nxTunIpv4Dst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<SrcNxTunIpv4DstCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxTunIpv4Dst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!SrcNxTunIpv4DstCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            SrcNxTunIpv4DstCase other = (SrcNxTunIpv4DstCase)obj;
            if (!Objects.equals(_nxTunIpv4Dst, other.isNxTunIpv4Dst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                SrcNxTunIpv4DstCaseImpl otherImpl = (SrcNxTunIpv4DstCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<SrcNxTunIpv4DstCase>>, Augmentation<SrcNxTunIpv4DstCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("SrcNxTunIpv4DstCase");
            CodeHelpers.appendValue(helper, "_nxTunIpv4Dst", _nxTunIpv4Dst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
