package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.dst.choice;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import java.lang.Boolean;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link DstNxNspCaseBuilder} instances.
 *
 * @see DstNxNspCaseBuilder
 *
 */
public class DstNxNspCaseBuilder implements Builder<DstNxNspCase> {

    private Boolean _nxNspDst;


    Map<Class<? extends Augmentation<DstNxNspCase>>, Augmentation<DstNxNspCase>> augmentation = Collections.emptyMap();

    public DstNxNspCaseBuilder() {
    }
    public DstNxNspCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping arg) {
        this._nxNspDst = arg.isNxNspDst();
    }

    public DstNxNspCaseBuilder(DstNxNspCase base) {
        this._nxNspDst = base.isNxNspDst();
        if (base instanceof DstNxNspCaseImpl) {
            DstNxNspCaseImpl impl = (DstNxNspCaseImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            Map<Class<? extends Augmentation<DstNxNspCase>>, Augmentation<DstNxNspCase>> aug =((AugmentationHolder<DstNxNspCase>) base).augmentations();
            if (!aug.isEmpty()) {
                this.augmentation = new HashMap<>(aug);
            }
        }
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping) {
            this._nxNspDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping)arg).isNxNspDst();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxmNxNspGrouping]");
    }

    public Boolean isNxNspDst() {
        return _nxNspDst;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<DstNxNspCase>> E augmentation(Class<E> augmentationType) {
        return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
    }

    
    public DstNxNspCaseBuilder setNxNspDst(final Boolean value) {
        this._nxNspDst = value;
        return this;
    }
    
    public DstNxNspCaseBuilder addAugmentation(Class<? extends Augmentation<DstNxNspCase>> augmentationType, Augmentation<DstNxNspCase> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public DstNxNspCaseBuilder removeAugmentation(Class<? extends Augmentation<DstNxNspCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public DstNxNspCase build() {
        return new DstNxNspCaseImpl(this);
    }

    private static final class DstNxNspCaseImpl implements DstNxNspCase {
    
        private final Boolean _nxNspDst;
    
        private Map<Class<? extends Augmentation<DstNxNspCase>>, Augmentation<DstNxNspCase>> augmentation = Collections.emptyMap();
    
        DstNxNspCaseImpl(DstNxNspCaseBuilder base) {
            this._nxNspDst = base.isNxNspDst();
            this.augmentation = ImmutableMap.copyOf(base.augmentation);
        }
    
        @Override
        public Class<DstNxNspCase> getImplementedInterface() {
            return DstNxNspCase.class;
        }
    
        @Override
        public Boolean isNxNspDst() {
            return _nxNspDst;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<DstNxNspCase>> E augmentation(Class<E> augmentationType) {
            return (E) augmentation.get(CodeHelpers.nonNullValue(augmentationType, "augmentationType"));
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxNspDst);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!DstNxNspCase.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            DstNxNspCase other = (DstNxNspCase)obj;
            if (!Objects.equals(_nxNspDst, other.isNxNspDst())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                DstNxNspCaseImpl otherImpl = (DstNxNspCaseImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<Class<? extends Augmentation<DstNxNspCase>>, Augmentation<DstNxNspCase>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.augmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }
    
        @Override
        public String toString() {
            final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("DstNxNspCase");
            CodeHelpers.appendValue(helper, "_nxNspDst", _nxNspDst);
            CodeHelpers.appendValue(helper, "augmentation", augmentation.values());
            return helper.toString();
        }
    }
}
