/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping;

import com.google.common.collect.Range;
import java.lang.reflect.Array;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn.FlowMods;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxLearnBuilder
implements Builder<NxLearn> {
    private BigInteger _cookie;
    private Integer _finHardTimeout;
    private Integer _finIdleTimeout;
    private Integer _flags;
    private List<FlowMods> _flowMods;
    private Integer _hardTimeout;
    private Integer _idleTimeout;
    private Integer _priority;
    private Short _tableId;
    Map<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> augmentation = Collections.emptyMap();
    private static final Range<BigInteger>[] CHECKCOOKIERANGE_RANGES;

    public NxLearnBuilder() {
    }

    public NxLearnBuilder(NxLearn base) {
        AugmentationHolder casted;
        this._cookie = base.getCookie();
        this._finHardTimeout = base.getFinHardTimeout();
        this._finIdleTimeout = base.getFinIdleTimeout();
        this._flags = base.getFlags();
        this._flowMods = base.getFlowMods();
        this._hardTimeout = base.getHardTimeout();
        this._idleTimeout = base.getIdleTimeout();
        this._priority = base.getPriority();
        this._tableId = base.getTableId();
        if (base instanceof NxLearnImpl) {
            NxLearnImpl impl = (NxLearnImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>>(casted.augmentations());
        }
    }

    public BigInteger getCookie() {
        return this._cookie;
    }

    public Integer getFinHardTimeout() {
        return this._finHardTimeout;
    }

    public Integer getFinIdleTimeout() {
        return this._finIdleTimeout;
    }

    public Integer getFlags() {
        return this._flags;
    }

    public List<FlowMods> getFlowMods() {
        return this._flowMods;
    }

    public Integer getHardTimeout() {
        return this._hardTimeout;
    }

    public Integer getIdleTimeout() {
        return this._idleTimeout;
    }

    public Integer getPriority() {
        return this._priority;
    }

    public Short getTableId() {
        return this._tableId;
    }

    public <E extends Augmentation<NxLearn>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCookieRange(BigInteger value) {
        for (Range<BigInteger> r : CHECKCOOKIERANGE_RANGES) {
            if (!r.contains((Comparable)value)) continue;
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: %s.", value, Arrays.asList(CHECKCOOKIERANGE_RANGES)));
    }

    public NxLearnBuilder setCookie(BigInteger value) {
        if (value != null) {
            NxLearnBuilder.checkCookieRange(value);
        }
        this._cookie = value;
        return this;
    }

    private static void checkFinHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setFinHardTimeout(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkFinHardTimeoutRange(value);
        }
        this._finHardTimeout = value;
        return this;
    }

    private static void checkFinIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setFinIdleTimeout(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkFinIdleTimeoutRange(value);
        }
        this._finIdleTimeout = value;
        return this;
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setFlags(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    public NxLearnBuilder setFlowMods(List<FlowMods> value) {
        this._flowMods = value;
        return this;
    }

    private static void checkHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setHardTimeout(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkHardTimeoutRange(value);
        }
        this._hardTimeout = value;
        return this;
    }

    private static void checkIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setIdleTimeout(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkIdleTimeoutRange(value);
        }
        this._idleTimeout = value;
        return this;
    }

    private static void checkPriorityRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxLearnBuilder setPriority(Integer value) {
        if (value != null) {
            NxLearnBuilder.checkPriorityRange(value);
        }
        this._priority = value;
        return this;
    }

    private static void checkTableIdRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
    }

    public NxLearnBuilder setTableId(Short value) {
        if (value != null) {
            NxLearnBuilder.checkTableIdRange(value);
        }
        this._tableId = value;
        return this;
    }

    public NxLearnBuilder addAugmentation(Class<? extends Augmentation<NxLearn>> augmentationType, Augmentation<NxLearn> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxLearnBuilder removeAugmentation(Class<? extends Augmentation<NxLearn>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxLearn build() {
        return new NxLearnImpl(this);
    }

    static {
        Range[] a = (Range[])Array.newInstance(Range.class, 1);
        a[0] = Range.closed((Comparable)BigInteger.ZERO, (Comparable)new BigInteger("18446744073709551615"));
        CHECKCOOKIERANGE_RANGES = a;
    }

    private static final class NxLearnImpl
    implements NxLearn {
        private final BigInteger _cookie;
        private final Integer _finHardTimeout;
        private final Integer _finIdleTimeout;
        private final Integer _flags;
        private final List<FlowMods> _flowMods;
        private final Integer _hardTimeout;
        private final Integer _idleTimeout;
        private final Integer _priority;
        private final Short _tableId;
        private Map<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxLearn> getImplementedInterface() {
            return NxLearn.class;
        }

        private NxLearnImpl(NxLearnBuilder base) {
            this._cookie = base.getCookie();
            this._finHardTimeout = base.getFinHardTimeout();
            this._finIdleTimeout = base.getFinIdleTimeout();
            this._flags = base.getFlags();
            this._flowMods = base.getFlowMods();
            this._hardTimeout = base.getHardTimeout();
            this._idleTimeout = base.getIdleTimeout();
            this._priority = base.getPriority();
            this._tableId = base.getTableId();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>>(base.augmentation);
                }
            }
        }

        @Override
        public BigInteger getCookie() {
            return this._cookie;
        }

        @Override
        public Integer getFinHardTimeout() {
            return this._finHardTimeout;
        }

        @Override
        public Integer getFinIdleTimeout() {
            return this._finIdleTimeout;
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public List<FlowMods> getFlowMods() {
            return this._flowMods;
        }

        @Override
        public Integer getHardTimeout() {
            return this._hardTimeout;
        }

        @Override
        public Integer getIdleTimeout() {
            return this._idleTimeout;
        }

        @Override
        public Integer getPriority() {
            return this._priority;
        }

        @Override
        public Short getTableId() {
            return this._tableId;
        }

        public <E extends Augmentation<NxLearn>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._cookie);
            result = 31 * result + Objects.hashCode(this._finHardTimeout);
            result = 31 * result + Objects.hashCode(this._finIdleTimeout);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._flowMods);
            result = 31 * result + Objects.hashCode(this._hardTimeout);
            result = 31 * result + Objects.hashCode(this._idleTimeout);
            result = 31 * result + Objects.hashCode(this._priority);
            result = 31 * result + Objects.hashCode(this._tableId);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxLearn.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxLearn other = (NxLearn)obj;
            if (!Objects.equals(this._cookie, other.getCookie())) {
                return false;
            }
            if (!Objects.equals(this._finHardTimeout, other.getFinHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._finIdleTimeout, other.getFinIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._flowMods, other.getFlowMods())) {
                return false;
            }
            if (!Objects.equals(this._hardTimeout, other.getHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._idleTimeout, other.getIdleTimeout())) {
                return false;
            }
            if (!Objects.equals(this._priority, other.getPriority())) {
                return false;
            }
            if (!Objects.equals(this._tableId, other.getTableId())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxLearnImpl otherImpl = (NxLearnImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxLearn>>, Augmentation<NxLearn>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxLearn [";
            StringBuilder builder = new StringBuilder(name);
            if (this._cookie != null) {
                builder.append("_cookie=");
                builder.append(this._cookie);
                builder.append(", ");
            }
            if (this._finHardTimeout != null) {
                builder.append("_finHardTimeout=");
                builder.append(this._finHardTimeout);
                builder.append(", ");
            }
            if (this._finIdleTimeout != null) {
                builder.append("_finIdleTimeout=");
                builder.append(this._finIdleTimeout);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._flowMods != null) {
                builder.append("_flowMods=");
                builder.append(this._flowMods);
                builder.append(", ");
            }
            if (this._hardTimeout != null) {
                builder.append("_hardTimeout=");
                builder.append(this._hardTimeout);
                builder.append(", ");
            }
            if (this._idleTimeout != null) {
                builder.append("_idleTimeout=");
                builder.append(this._idleTimeout);
                builder.append(", ");
            }
            if (this._priority != null) {
                builder.append("_priority=");
                builder.append(this._priority);
                builder.append(", ");
            }
            if (this._tableId != null) {
                builder.append("_tableId=");
                builder.append(this._tableId);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

