/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.output.to.port._case.FlowModOutputToPort;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class FlowModOutputToPortBuilder
implements Builder<FlowModOutputToPort> {
    private Integer _flowModNumBits;
    private Long _srcField;
    private Integer _srcOfs;
    Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> augmentation = Collections.emptyMap();

    public FlowModOutputToPortBuilder() {
    }

    public FlowModOutputToPortBuilder(FlowModOutputToPort base) {
        AugmentationHolder casted;
        this._flowModNumBits = base.getFlowModNumBits();
        this._srcField = base.getSrcField();
        this._srcOfs = base.getSrcOfs();
        if (base instanceof FlowModOutputToPortImpl) {
            FlowModOutputToPortImpl impl = (FlowModOutputToPortImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>(casted.augmentations());
        }
    }

    public Integer getFlowModNumBits() {
        return this._flowModNumBits;
    }

    public Long getSrcField() {
        return this._srcField;
    }

    public Integer getSrcOfs() {
        return this._srcOfs;
    }

    public <E extends Augmentation<FlowModOutputToPort>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkFlowModNumBitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public FlowModOutputToPortBuilder setFlowModNumBits(Integer value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkFlowModNumBitsRange(value);
        }
        this._flowModNumBits = value;
        return this;
    }

    private static void checkSrcFieldRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
    }

    public FlowModOutputToPortBuilder setSrcField(Long value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkSrcFieldRange(value);
        }
        this._srcField = value;
        return this;
    }

    private static void checkSrcOfsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public FlowModOutputToPortBuilder setSrcOfs(Integer value) {
        if (value != null) {
            FlowModOutputToPortBuilder.checkSrcOfsRange(value);
        }
        this._srcOfs = value;
        return this;
    }

    public FlowModOutputToPortBuilder addAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType, Augmentation<FlowModOutputToPort> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public FlowModOutputToPortBuilder removeAugmentation(Class<? extends Augmentation<FlowModOutputToPort>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public FlowModOutputToPort build() {
        return new FlowModOutputToPortImpl(this);
    }

    private static final class FlowModOutputToPortImpl
    implements FlowModOutputToPort {
        private final Integer _flowModNumBits;
        private final Long _srcField;
        private final Integer _srcOfs;
        private Map<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<FlowModOutputToPort> getImplementedInterface() {
            return FlowModOutputToPort.class;
        }

        private FlowModOutputToPortImpl(FlowModOutputToPortBuilder base) {
            this._flowModNumBits = base.getFlowModNumBits();
            this._srcField = base.getSrcField();
            this._srcOfs = base.getSrcOfs();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getFlowModNumBits() {
            return this._flowModNumBits;
        }

        @Override
        public Long getSrcField() {
            return this._srcField;
        }

        @Override
        public Integer getSrcOfs() {
            return this._srcOfs;
        }

        public <E extends Augmentation<FlowModOutputToPort>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._flowModNumBits);
            result = 31 * result + Objects.hashCode(this._srcField);
            result = 31 * result + Objects.hashCode(this._srcOfs);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!FlowModOutputToPort.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            FlowModOutputToPort other = (FlowModOutputToPort)obj;
            if (!Objects.equals(this._flowModNumBits, other.getFlowModNumBits())) {
                return false;
            }
            if (!Objects.equals(this._srcField, other.getSrcField())) {
                return false;
            }
            if (!Objects.equals(this._srcOfs, other.getSrcOfs())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                FlowModOutputToPortImpl otherImpl = (FlowModOutputToPortImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<FlowModOutputToPort>>, Augmentation<FlowModOutputToPort>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "FlowModOutputToPort [";
            StringBuilder builder = new StringBuilder(name);
            if (this._flowModNumBits != null) {
                builder.append("_flowModNumBits=");
                builder.append(this._flowModNumBits);
                builder.append(", ");
            }
            if (this._srcField != null) {
                builder.append("_srcField=");
                builder.append(this._srcField);
                builder.append(", ");
            }
            if (this._srcOfs != null) {
                builder.append("_srcOfs=");
                builder.append(this._srcOfs);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

