package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-action-fin-timeout {
 *     leaf fin-idle-timeout {
 *         type uint16;
 *     }
 *     leaf fin-hard-timeout {
 *         type uint16;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-fin-timeout-grouping/nx-action-fin-timeout</i>
 *
 * <p>To create instances of this class use {@link NxActionFinTimeoutBuilder}.
 * @see NxActionFinTimeoutBuilder
 *
 */
public interface NxActionFinTimeout
    extends
    ChildOf<NxActionFinTimeoutGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-action-fin-timeout").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>finIdleTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFinIdleTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>finHardTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFinHardTimeout();

}

