package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.OfpactActions;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * list ct-actions {
 *     choice ofpact-actions {
 *         case nx-action-ct-mark-case {
 *             container nx-action-ct-mark {
 *                 leaf ct-mark {
 *                     type uint32;
 *                 }
 *             }
 *         }
 *         case nx-action-nat-case {
 *             container nx-action-nat {
 *                 leaf flags {
 *                     type uint16;
 *                 }
 *                 leaf range_present {
 *                     type uint16;
 *                 }
 *                 leaf ip-address-min {
 *                     type ip-address;
 *                 }
 *                 leaf ip-address-max {
 *                     type ip-address;
 *                 }
 *                 leaf port-min {
 *                     type uint16;
 *                 }
 *                 leaf port-max {
 *                     type uint16;
 *                 }
 *             }
 *         }
 *     }
 *     uses ofpact-actions;
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping/nx-conntrack/ct-actions</i>
 *
 * <p>To create instances of this class use {@link CtActionsBuilder}.
 * @see CtActionsBuilder
 *
 *
 */
public interface CtActions
    extends
    ChildOf<NxConntrack>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions>,
    OfpactActions
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "ct-actions").intern();


}

