package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <pre>
 * container nxm-of-udp-src {
 *     leaf port {
 *         type port-number;
 *     }
 *     leaf mask {
 *         type uint16;
 *     }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-match/nxm-of-udp-src-grouping/nxm-of-udp-src</i>
 *
 * <p>To create instances of this class use {@link NxmOfUdpSrcBuilder}.
 * @see NxmOfUdpSrcBuilder
 *
 */
public interface NxmOfUdpSrc
    extends
    ChildOf<NxmOfUdpSrcGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping.NxmOfUdpSrc>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:match",
        "2014-07-14", "nxm-of-udp-src").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber</code> <code>port</code>, or <code>null</code> if not present
     */
    PortNumber getPort();
    
    /**
     * @return <code>java.lang.Integer</code> <code>mask</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMask();

}

