package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.nx.conntrack.CtActions;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.List;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack
 *
 */
public class NxConntrackBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> {

    private java.lang.Integer _conntrackZone;
    private List<CtActions> _ctActions;
    private java.lang.Integer _flags;
    private java.lang.Short _recircTable;
    private java.lang.Long _zoneSrc;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> augmentation = Collections.emptyMap();

    public NxConntrackBuilder() {
    }

    public NxConntrackBuilder(NxConntrack base) {
        this._conntrackZone = base.getConntrackZone();
        this._ctActions = base.getCtActions();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
        if (base instanceof NxConntrackImpl) {
            NxConntrackImpl impl = (NxConntrackImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getConntrackZone() {
        return _conntrackZone;
    }
    
    public List<CtActions> getCtActions() {
        return _ctActions;
    }
    
    public java.lang.Integer getFlags() {
        return _flags;
    }
    
    public java.lang.Short getRecircTable() {
        return _recircTable;
    }
    
    public java.lang.Long getZoneSrc() {
        return _zoneSrc;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkConntrackZoneRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
     }
    
    public NxConntrackBuilder setConntrackZone(final java.lang.Integer value) {
    if (value != null) {
        checkConntrackZoneRange(value);
    }
        this._conntrackZone = value;
        return this;
    }
    
     
    public NxConntrackBuilder setCtActions(final List<CtActions> value) {
        this._ctActions = value;
        return this;
    }
    
     
     private static void checkFlagsRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
     }
    
    public NxConntrackBuilder setFlags(final java.lang.Integer value) {
    if (value != null) {
        checkFlagsRange(value);
    }
        this._flags = value;
        return this;
    }
    
     
     private static void checkRecircTableRange(final short value) {
         if (value >= (short)0 && value <= (short)255) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..255]].", value));
     }
    
    public NxConntrackBuilder setRecircTable(final java.lang.Short value) {
    if (value != null) {
        checkRecircTableRange(value);
    }
        this._recircTable = value;
        return this;
    }
    
     
     private static void checkZoneSrcRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..4294967295]].", value));
     }
    
    public NxConntrackBuilder setZoneSrc(final java.lang.Long value) {
    if (value != null) {
        checkZoneSrcRange(value);
    }
        this._zoneSrc = value;
        return this;
    }
    
    public NxConntrackBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> augmentationValue) {
        if (augmentationValue == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }
    
    public NxConntrackBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxConntrack build() {
        return new NxConntrackImpl(this);
    }

    private static final class NxConntrackImpl implements NxConntrack {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack.class;
        }

        private final java.lang.Integer _conntrackZone;
        private final List<CtActions> _ctActions;
        private final java.lang.Integer _flags;
        private final java.lang.Short _recircTable;
        private final java.lang.Long _zoneSrc;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> augmentation = Collections.emptyMap();

        private NxConntrackImpl(NxConntrackBuilder base) {
            this._conntrackZone = base.getConntrackZone();
            this._ctActions = base.getCtActions();
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getConntrackZone() {
            return _conntrackZone;
        }
        
        @Override
        public List<CtActions> getCtActions() {
            return _ctActions;
        }
        
        @Override
        public java.lang.Integer getFlags() {
            return _flags;
        }
        
        @Override
        public java.lang.Short getRecircTable() {
            return _recircTable;
        }
        
        @Override
        public java.lang.Long getZoneSrc() {
            return _zoneSrc;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_conntrackZone);
            result = prime * result + Objects.hashCode(_ctActions);
            result = prime * result + Objects.hashCode(_flags);
            result = prime * result + Objects.hashCode(_recircTable);
            result = prime * result + Objects.hashCode(_zoneSrc);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack other = (org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack)obj;
            if (!Objects.equals(_conntrackZone, other.getConntrackZone())) {
                return false;
            }
            if (!Objects.equals(_ctActions, other.getCtActions())) {
                return false;
            }
            if (!Objects.equals(_flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(_recircTable, other.getRecircTable())) {
                return false;
            }
            if (!Objects.equals(_zoneSrc, other.getZoneSrc())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxConntrackImpl otherImpl = (NxConntrackImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "NxConntrack [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_conntrackZone != null) {
                builder.append("_conntrackZone=");
                builder.append(_conntrackZone);
                builder.append(", ");
            }
            if (_ctActions != null) {
                builder.append("_ctActions=");
                builder.append(_ctActions);
                builder.append(", ");
            }
            if (_flags != null) {
                builder.append("_flags=");
                builder.append(_flags);
                builder.append(", ");
            }
            if (_recircTable != null) {
                builder.append("_recircTable=");
                builder.append(_recircTable);
                builder.append(", ");
            }
            if (_zoneSrc != null) {
                builder.append("_zoneSrc=");
                builder.append(_zoneSrc);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
