package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn.FlowMods;
import org.opendaylight.yangtools.yang.common.QName;
import java.math.BigInteger;
import java.util.List;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-learn {
 *     leaf idle-timeout {
 *         type uint16;
 *     }
 *     leaf hard-timeout {
 *         type uint16;
 *     }
 *     leaf priority {
 *         type uint16;
 *     }
 *     leaf cookie {
 *         type uint64;
 *     }
 *     leaf flags {
 *         type uint16;
 *     }
 *     leaf table-id {
 *         type uint8;
 *     }
 *     leaf fin-idle-timeout {
 *         type uint16;
 *     }
 *     leaf fin-hard-timeout {
 *         type uint16;
 *     }
 *     list flow-mods {
 *         choice flow-mod-spec {
 *             case flow-mod-add-match-from-field-case {
 *                 container flow-mod-add-match-from-field {
 *                     leaf flow-mod-num-bits {
 *                         type uint16;
 *                     }
 *                     leaf src-field {
 *                         type uint32;
 *                     }
 *                     leaf src-ofs {
 *                         type uint16;
 *                     }
 *                     leaf dst-field {
 *                         type uint32;
 *                     }
 *                     leaf dst-ofs {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *             case flow-mod-add-match-from-value-case {
 *                 container flow-mod-add-match-from-value {
 *                     leaf flow-mod-num-bits {
 *                         type uint16;
 *                     }
 *                     leaf value {
 *                         type uint16;
 *                     }
 *                     leaf src-field {
 *                         type uint32;
 *                     }
 *                     leaf src-ofs {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *             case flow-mod-copy-field-into-field-case {
 *                 container flow-mod-copy-field-into-field {
 *                     leaf flow-mod-num-bits {
 *                         type uint16;
 *                     }
 *                     leaf src-field {
 *                         type uint32;
 *                     }
 *                     leaf src-ofs {
 *                         type uint16;
 *                     }
 *                     leaf dst-field {
 *                         type uint32;
 *                     }
 *                     leaf dst-ofs {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *             case flow-mod-copy-value-into-field-case {
 *                 container flow-mod-copy-value-into-field {
 *                     leaf flow-mod-num-bits {
 *                         type uint16;
 *                     }
 *                     leaf value {
 *                         type uint16;
 *                     }
 *                     leaf dst-field {
 *                         type uint32;
 *                     }
 *                     leaf dst-ofs {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *             case flow-mod-output-to-port-case {
 *                 container flow-mod-output-to-port {
 *                     leaf flow-mod-num-bits {
 *                         type uint16;
 *                     }
 *                     leaf src-field {
 *                         type uint32;
 *                     }
 *                     leaf src-ofs {
 *                         type uint16;
 *                     }
 *                 }
 *             }
 *         }
 *         uses flow-mod-spec;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-learn-grouping/nx-learn</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearnBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearnBuilder
 *
 */
public interface NxLearn
    extends
    ChildOf<NxActionLearnGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-learn").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>idleTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getIdleTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>hardTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getHardTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>priority</code>, or <code>null</code> if not present
     */
    java.lang.Integer getPriority();
    
    /**
     * @return <code>java.math.BigInteger</code> <code>cookie</code>, or <code>null</code> if not present
     */
    BigInteger getCookie();
    
    /**
     * @return <code>java.lang.Integer</code> <code>flags</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFlags();
    
    /**
     * @return <code>java.lang.Short</code> <code>tableId</code>, or <code>null</code> if not present
     */
    java.lang.Short getTableId();
    
    /**
     * @return <code>java.lang.Integer</code> <code>finIdleTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFinIdleTimeout();
    
    /**
     * @return <code>java.lang.Integer</code> <code>finHardTimeout</code>, or <code>null</code> if not present
     */
    java.lang.Integer getFinHardTimeout();
    
    /**
     * @return <code>java.util.List</code> <code>flowMods</code>, or <code>null</code> if not present
     */
    List<FlowMods> getFlowMods();

}

