/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.dst.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.dst.grouping.NxmOfUdpDst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmOfUdpDstBuilder
implements Builder<NxmOfUdpDst> {
    private Integer _mask;
    private PortNumber _port;
    Map<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> augmentation = Collections.emptyMap();

    public NxmOfUdpDstBuilder() {
    }

    public NxmOfUdpDstBuilder(NxmOfUdpDst base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._port = base.getPort();
        if (base instanceof NxmOfUdpDstImpl) {
            NxmOfUdpDstImpl impl = (NxmOfUdpDstImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>>(casted.augmentations());
        }
    }

    public Integer getMask() {
        return this._mask;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<NxmOfUdpDst>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaskRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0..65535]].", value));
    }

    public NxmOfUdpDstBuilder setMask(Integer value) {
        if (value != null) {
            NxmOfUdpDstBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmOfUdpDstBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public NxmOfUdpDstBuilder addAugmentation(Class<? extends Augmentation<NxmOfUdpDst>> augmentationType, Augmentation<NxmOfUdpDst> augmentationValue) {
        if (augmentationValue == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>>();
        }
        this.augmentation.put(augmentationType, augmentationValue);
        return this;
    }

    public NxmOfUdpDstBuilder removeAugmentation(Class<? extends Augmentation<NxmOfUdpDst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmOfUdpDst build() {
        return new NxmOfUdpDstImpl(this);
    }

    private static final class NxmOfUdpDstImpl
    implements NxmOfUdpDst {
        private final Integer _mask;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxmOfUdpDst> getImplementedInterface() {
            return NxmOfUdpDst.class;
        }

        private NxmOfUdpDstImpl(NxmOfUdpDstBuilder base) {
            this._mask = base.getMask();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMask() {
            return this._mask;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<NxmOfUdpDst>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._port);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfUdpDst.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfUdpDst other = (NxmOfUdpDst)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmOfUdpDstImpl otherImpl = (NxmOfUdpDstImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmOfUdpDst>>, Augmentation<NxmOfUdpDst>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxmOfUdpDst [";
            StringBuilder builder = new StringBuilder(name);
            if (this._mask != null) {
                builder.append("_mask=");
                builder.append(this._mask);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

