/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action;

import com.google.common.base.Preconditions;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionFromOFJava;
import org.opendaylight.openflowplugin.extension.api.ConvertorActionToOFJava;
import org.opendaylight.openflowplugin.extension.api.path.ActionPath;
import org.opendaylight.openflowplugin.extension.api.path.AugmentationPath;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.CodecPreconditionException;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action.ActionUtil;
import org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action.RegMoveConvertor;
import org.opendaylight.yang.gen.v1.urn.opendaylight.action.types.rev131112.action.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.action.container.action.choice.ActionMultipathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.multipath.grouping.NxActionMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.ofj.nx.action.multipath.grouping.NxActionMultipathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionMultipathNotifFlowsStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flows.statistics.update.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionMultipathNotifFlowsStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionMultipathNotifDirectStatisticsUpdateApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.get.flow.statistics.output.flow.and.statistics.map.list.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionMultipathNotifDirectStatisticsUpdateWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.group.desc.stats.updated.group.desc.stats.buckets.bucket.action.action.NxActionMultipathNotifGroupDescStatsUpdatedCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action.NxActionMultipathNodesNodeTableFlowApplyActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action.NxActionMultipathNodesNodeTableFlowWriteActionsCaseBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipathBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.DstBuilder;

public class MultipathConvertor
implements ConvertorActionToOFJava<Action, org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action>,
ConvertorActionFromOFJava<org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action, ActionPath> {
    public Action convert(org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action input, ActionPath path) {
        NxActionMultipath action = ((ActionMultipath)input.getActionChoice()).getNxActionMultipath();
        DstBuilder dstBuilder = new DstBuilder();
        dstBuilder.setDstChoice(RegMoveConvertor.resolveDst(action.getDst()));
        dstBuilder.setStart(MultipathConvertor.resolveStart(action.getOfsNbits()));
        dstBuilder.setEnd(MultipathConvertor.resolveEnd(action.getOfsNbits()));
        NxMultipathBuilder builder = new NxMultipathBuilder();
        builder.setBasis(action.getBasis());
        builder.setAlgorithm(action.getAlgorithm());
        builder.setMaxLink(action.getMaxLink());
        builder.setArg(action.getArg());
        builder.setDst(dstBuilder.build());
        return MultipathConvertor.resolveAction(builder.build(), path);
    }

    private static int resolveStart(int ofsNBints) {
        return MultipathConvertor.extractSub(ofsNBints, 10, 6);
    }

    private static int resolveEnd(int ofsNBints) {
        int ofs = MultipathConvertor.extractSub(ofsNBints, 10, 6);
        int nBits = MultipathConvertor.extractSub(ofsNBints, 6, 0);
        return ofs + nBits;
    }

    private static int extractSub(int l, int nrBits, int offset) {
        int rightShifted = l >>> offset;
        int mask = (1 << nrBits) - 1;
        return rightShifted & mask;
    }

    private static Action resolveAction(NxMultipath value, ActionPath path) {
        switch (path) {
            case NODES_NODE_TABLE_FLOW_INSTRUCTIONS_INSTRUCTION_WRITEACTIONSCASE_WRITEACTIONS_ACTION_ACTION_EXTENSIONLIST_EXTENSION: {
                return new NxActionMultipathNodesNodeTableFlowWriteActionsCaseBuilder().setNxMultipath(value).build();
            }
            case FLOWSSTATISTICSUPDATE_FLOWANDSTATISTICSMAPLIST_INSTRUCTIONS_INSTRUCTION_INSTRUCTION_WRITEACTIONSCASE_WRITEACTIONS_ACTION_ACTION: {
                return new NxActionMultipathNotifFlowsStatisticsUpdateWriteActionsCaseBuilder().setNxMultipath(value).build();
            }
            case FLOWSSTATISTICSUPDATE_FLOWANDSTATISTICSMAPLIST_INSTRUCTIONS_INSTRUCTION_INSTRUCTION_APPLYACTIONSCASE_APPLYACTIONS_ACTION_ACTION: {
                return new NxActionMultipathNotifFlowsStatisticsUpdateApplyActionsCaseBuilder().setNxMultipath(value).build();
            }
            case GROUPDESCSTATSUPDATED_GROUPDESCSTATS_BUCKETS_BUCKET_ACTION: {
                return new NxActionMultipathNotifGroupDescStatsUpdatedCaseBuilder().setNxMultipath(value).build();
            }
            case RPCFLOWSSTATISTICS_FLOWANDSTATISTICSMAPLIST_INSTRUCTIONS_INSTRUCTION_INSTRUCTION_WRITEACTIONSCASE_WRITEACTIONS_ACTION_ACTION: {
                return new NxActionMultipathNotifDirectStatisticsUpdateWriteActionsCaseBuilder().setNxMultipath(value).build();
            }
            case RPCFLOWSSTATISTICS_FLOWANDSTATISTICSMAPLIST_INSTRUCTIONS_INSTRUCTION_INSTRUCTION_APPLYACTIONSCASE_APPLYACTIONS_ACTION_ACTION: {
                return new NxActionMultipathNotifDirectStatisticsUpdateApplyActionsCaseBuilder().setNxMultipath(value).build();
            }
            case NODES_NODE_TABLE_FLOW_INSTRUCTIONS_INSTRUCTION_APPLYACTIONSCASE_APPLYACTIONS_ACTION_ACTION_EXTENSIONLIST_EXTENSION: {
                return new NxActionMultipathNodesNodeTableFlowApplyActionsCaseBuilder().setNxMultipath(value).build();
            }
        }
        throw new CodecPreconditionException((AugmentationPath)path);
    }

    public org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action convert(Action nxActionArg) {
        Preconditions.checkArgument((boolean)(nxActionArg instanceof NxActionMultipathGrouping));
        NxActionMultipathGrouping nxAction = (NxActionMultipathGrouping)nxActionArg;
        NxActionMultipathBuilder nxActionMultipathBuilder = new NxActionMultipathBuilder();
        nxActionMultipathBuilder.setFields(nxAction.getNxMultipath().getFields());
        nxActionMultipathBuilder.setBasis(nxAction.getNxMultipath().getBasis());
        nxActionMultipathBuilder.setAlgorithm(nxAction.getNxMultipath().getAlgorithm());
        nxActionMultipathBuilder.setMaxLink(nxAction.getNxMultipath().getMaxLink());
        nxActionMultipathBuilder.setArg(nxAction.getNxMultipath().getArg());
        Dst dst = nxAction.getNxMultipath().getDst();
        nxActionMultipathBuilder.setOfsNbits(Integer.valueOf(dst.getStart() << 6 | dst.getEnd() - dst.getStart()));
        nxActionMultipathBuilder.setDst(Long.valueOf(RegMoveConvertor.resolveDst(dst.getDstChoice())));
        ActionMultipathBuilder actionMultipathBuilder = new ActionMultipathBuilder();
        actionMultipathBuilder.setNxActionMultipath(nxActionMultipathBuilder.build());
        return ActionUtil.createAction((ActionChoice)actionMultipathBuilder.build());
    }
}

