/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping.NxmNxNsi;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmNxNsiBuilder
implements Builder<NxmNxNsi> {
    private Short _nsi;
    Map<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> augmentation = Collections.emptyMap();

    public NxmNxNsiBuilder() {
    }

    public NxmNxNsiBuilder(NxmNxNsi base) {
        AugmentationHolder casted;
        this._nsi = base.getNsi();
        if (base instanceof NxmNxNsiImpl) {
            NxmNxNsiImpl impl = (NxmNxNsiImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>>(casted.augmentations());
        }
    }

    public Short getNsi() {
        return this._nsi;
    }

    public <E extends Augmentation<NxmNxNsi>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkNsiRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxmNxNsiBuilder setNsi(Short value) {
        if (value != null) {
            NxmNxNsiBuilder.checkNsiRange(value);
        }
        this._nsi = value;
        return this;
    }

    public NxmNxNsiBuilder addAugmentation(Class<? extends Augmentation<NxmNxNsi>> augmentationType, Augmentation<NxmNxNsi> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxmNxNsiBuilder removeAugmentation(Class<? extends Augmentation<NxmNxNsi>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmNxNsi build() {
        return new NxmNxNsiImpl(this);
    }

    private static final class NxmNxNsiImpl
    implements NxmNxNsi {
        private final Short _nsi;
        private Map<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxmNxNsi> getImplementedInterface() {
            return NxmNxNsi.class;
        }

        private NxmNxNsiImpl(NxmNxNsiBuilder base) {
            this._nsi = base.getNsi();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>>(base.augmentation);
                }
            }
        }

        @Override
        public Short getNsi() {
            return this._nsi;
        }

        public <E extends Augmentation<NxmNxNsi>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._nsi);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmNxNsi.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmNxNsi other = (NxmNxNsi)obj;
            if (!Objects.equals(this._nsi, other.getNsi())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmNxNsiImpl otherImpl = (NxmNxNsiImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmNxNsi>>, Augmentation<NxmNxNsi>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxmNxNsi [";
            StringBuilder builder = new StringBuilder(name);
            if (this._nsi != null) {
                builder.append("_nsi=");
                builder.append(this._nsi);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

