/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.ct.mark._case.NxActionCtMark;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionCtMarkBuilder
implements Builder<NxActionCtMark> {
    private Long _ctMark;
    Map<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> augmentation = Collections.emptyMap();

    public NxActionCtMarkBuilder() {
    }

    public NxActionCtMarkBuilder(NxActionCtMark base) {
        AugmentationHolder casted;
        this._ctMark = base.getCtMark();
        if (base instanceof NxActionCtMarkImpl) {
            NxActionCtMarkImpl impl = (NxActionCtMarkImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>(casted.augmentations());
        }
    }

    public Long getCtMark() {
        return this._ctMark;
    }

    public <E extends Augmentation<NxActionCtMark>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkCtMarkRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxActionCtMarkBuilder setCtMark(Long value) {
        if (value != null) {
            NxActionCtMarkBuilder.checkCtMarkRange(value);
        }
        this._ctMark = value;
        return this;
    }

    public NxActionCtMarkBuilder addAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType, Augmentation<NxActionCtMark> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionCtMarkBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtMark>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionCtMark build() {
        return new NxActionCtMarkImpl(this);
    }

    private static final class NxActionCtMarkImpl
    implements NxActionCtMark {
        private final Long _ctMark;
        private Map<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionCtMark> getImplementedInterface() {
            return NxActionCtMark.class;
        }

        private NxActionCtMarkImpl(NxActionCtMarkBuilder base) {
            this._ctMark = base.getCtMark();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>>(base.augmentation);
                }
            }
        }

        @Override
        public Long getCtMark() {
            return this._ctMark;
        }

        public <E extends Augmentation<NxActionCtMark>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ctMark);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionCtMark.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionCtMark other = (NxActionCtMark)obj;
            if (!Objects.equals(this._ctMark, other.getCtMark())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionCtMarkImpl otherImpl = (NxActionCtMarkImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionCtMark>>, Augmentation<NxActionCtMark>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxActionCtMark [";
            StringBuilder builder = new StringBuilder(name);
            if (this._ctMark != null) {
                builder.append("_ctMark=");
                builder.append(this._ctMark);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

