/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.dst.choice.grouping.DstChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.nx.reg.move.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class DstBuilder
implements Builder<Dst> {
    private DstChoice _dstChoice;
    private Integer _end;
    private Integer _start;
    Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> augmentation = Collections.emptyMap();

    public DstBuilder() {
    }

    public DstBuilder(DstChoiceGrouping arg) {
        this._dstChoice = arg.getDstChoice();
    }

    public DstBuilder(RangeGrouping arg) {
        this._start = arg.getStart();
        this._end = arg.getEnd();
    }

    public DstBuilder(Dst base) {
        AugmentationHolder casted;
        this._dstChoice = base.getDstChoice();
        this._end = base.getEnd();
        this._start = base.getStart();
        if (base instanceof DstImpl) {
            DstImpl impl = (DstImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Dst>>, Augmentation<Dst>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dst>>, Augmentation<Dst>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof DstChoiceGrouping) {
            this._dstChoice = ((DstChoiceGrouping)arg).getDstChoice();
            isValidArg = true;
        }
        if (arg instanceof RangeGrouping) {
            this._start = ((RangeGrouping)arg).getStart();
            this._end = ((RangeGrouping)arg).getEnd();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.DstChoiceGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.RangeGrouping] \nbut was: " + arg);
        }
    }

    public DstChoice getDstChoice() {
        return this._dstChoice;
    }

    public Integer getEnd() {
        return this._end;
    }

    public Integer getStart() {
        return this._start;
    }

    public <E extends Augmentation<Dst>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public DstBuilder setDstChoice(DstChoice value) {
        this._dstChoice = value;
        return this;
    }

    private static void checkEndRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DstBuilder setEnd(Integer value) {
        if (value != null) {
            DstBuilder.checkEndRange(value);
        }
        this._end = value;
        return this;
    }

    private static void checkStartRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public DstBuilder setStart(Integer value) {
        if (value != null) {
            DstBuilder.checkStartRange(value);
        }
        this._start = value;
        return this;
    }

    public DstBuilder addAugmentation(Class<? extends Augmentation<Dst>> augmentationType, Augmentation<Dst> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Dst>>, Augmentation<Dst>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public DstBuilder removeAugmentation(Class<? extends Augmentation<Dst>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Dst build() {
        return new DstImpl(this);
    }

    private static final class DstImpl
    implements Dst {
        private final DstChoice _dstChoice;
        private final Integer _end;
        private final Integer _start;
        private Map<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Dst> getImplementedInterface() {
            return Dst.class;
        }

        private DstImpl(DstBuilder base) {
            this._dstChoice = base.getDstChoice();
            this._end = base.getEnd();
            this._start = base.getStart();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Dst>>, Augmentation<Dst>>(base.augmentation);
                }
            }
        }

        @Override
        public DstChoice getDstChoice() {
            return this._dstChoice;
        }

        @Override
        public Integer getEnd() {
            return this._end;
        }

        @Override
        public Integer getStart() {
            return this._start;
        }

        public <E extends Augmentation<Dst>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._dstChoice);
            result = 31 * result + Objects.hashCode(this._end);
            result = 31 * result + Objects.hashCode(this._start);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Dst.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Dst other = (Dst)obj;
            if (!Objects.equals(this._dstChoice, other.getDstChoice())) {
                return false;
            }
            if (!Objects.equals(this._end, other.getEnd())) {
                return false;
            }
            if (!Objects.equals(this._start, other.getStart())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                DstImpl otherImpl = (DstImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Dst>>, Augmentation<Dst>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "Dst [";
            StringBuilder builder = new StringBuilder(name);
            if (this._dstChoice != null) {
                builder.append("_dstChoice=");
                builder.append(this._dstChoice);
                builder.append(", ");
            }
            if (this._end != null) {
                builder.append("_end=");
                builder.append(this._end);
                builder.append(", ");
            }
            if (this._start != null) {
                builder.append("_start=");
                builder.append(this._start);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

