/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.ListIterator;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.Ipv4Address;

public final class IpConverter {
    public static long Ipv4AddressToLong(Ipv4Address ipv4Address) {
        long result = 0L;
        Iterable splitted = Splitter.on((char)'.').trimResults().omitEmptyStrings().split((CharSequence)ipv4Address.getValue());
        ArrayList splittedAddress = Lists.newArrayList(splitted.iterator());
        int maxIndex = splittedAddress.size() - 1;
        ListIterator listIter = splittedAddress.listIterator();
        while (listIter.hasNext()) {
            String current = (String)listIter.next();
            int i = splittedAddress.indexOf(current);
            result |= Long.parseLong(current) << (maxIndex - i) * 8;
        }
        return result & 0xFFFFFFFFFFFFFFFFL;
    }

    public static Ipv4Address longToIpv4Address(long ip) {
        long tmpIp = ip;
        StringBuilder sb = new StringBuilder(15);
        for (int i = 0; i < 4; ++i) {
            sb.insert(0, Long.toString(tmpIp & 0xFFL));
            if (i < 3) {
                sb.insert(0, '.');
            }
            tmpIp >>= 8;
        }
        return new Ipv4Address(sb.toString());
    }
}

