package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.src.grouping.NxmOfEthSrc;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <pre>
 * grouping nxm-of-eth-src-grouping {
 *     container nxm-of-eth-src {
 *         leaf mac-address {
 *             type mac-address;
 *         }
 *         uses mac-address-grouping;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-match/nxm-of-eth-src-grouping</i>
 *
 */
public interface NxmOfEthSrcGrouping
    extends
    DataObject
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:match",
        "2014-07-14", "nxm-of-eth-src-grouping").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.src.grouping.NxmOfEthSrc</code> <code>nxmOfEthSrc</code>, or <code>null</code> if not present
     */
    NxmOfEthSrc getNxmOfEthSrc();

}

