package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.IpAddress;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat
 *
 */
public class NxActionNatBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat> {

    private java.lang.Integer _flags;
    private IpAddress _ipAddressMax;
    private IpAddress _ipAddressMin;
    private java.lang.Integer _portMax;
    private java.lang.Integer _portMin;
    private java.lang.Integer _rangePresent;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> augmentation = Collections.emptyMap();

    public NxActionNatBuilder() {
    }

    public NxActionNatBuilder(NxActionNat base) {
        this._flags = base.getFlags();
        this._ipAddressMax = base.getIpAddressMax();
        this._ipAddressMin = base.getIpAddressMin();
        this._portMax = base.getPortMax();
        this._portMin = base.getPortMin();
        this._rangePresent = base.getRangePresent();
        if (base instanceof NxActionNatImpl) {
            NxActionNatImpl impl = (NxActionNatImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public java.lang.Integer getFlags() {
        return _flags;
    }
    
    public IpAddress getIpAddressMax() {
        return _ipAddressMax;
    }
    
    public IpAddress getIpAddressMin() {
        return _ipAddressMin;
    }
    
    public java.lang.Integer getPortMax() {
        return _portMax;
    }
    
    public java.lang.Integer getPortMin() {
        return _portMin;
    }
    
    public java.lang.Integer getRangePresent() {
        return _rangePresent;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
     private static void checkFlagsRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxActionNatBuilder setFlags(final java.lang.Integer value) {
    if (value != null) {
        checkFlagsRange(value);
    }
        this._flags = value;
        return this;
    }
    
     
    public NxActionNatBuilder setIpAddressMax(final IpAddress value) {
        this._ipAddressMax = value;
        return this;
    }
    
     
    public NxActionNatBuilder setIpAddressMin(final IpAddress value) {
        this._ipAddressMin = value;
        return this;
    }
    
     
     private static void checkPortMaxRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxActionNatBuilder setPortMax(final java.lang.Integer value) {
    if (value != null) {
        checkPortMaxRange(value);
    }
        this._portMax = value;
        return this;
    }
    
     
     private static void checkPortMinRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxActionNatBuilder setPortMin(final java.lang.Integer value) {
    if (value != null) {
        checkPortMinRange(value);
    }
        this._portMin = value;
        return this;
    }
    
     
     private static void checkRangePresentRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxActionNatBuilder setRangePresent(final java.lang.Integer value) {
    if (value != null) {
        checkRangePresentRange(value);
    }
        this._rangePresent = value;
        return this;
    }
    
    public NxActionNatBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NxActionNatBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionNat build() {
        return new NxActionNatImpl(this);
    }

    private static final class NxActionNatImpl implements NxActionNat {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat.class;
        }

        private final java.lang.Integer _flags;
        private final IpAddress _ipAddressMax;
        private final IpAddress _ipAddressMin;
        private final java.lang.Integer _portMax;
        private final java.lang.Integer _portMin;
        private final java.lang.Integer _rangePresent;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> augmentation = Collections.emptyMap();

        private NxActionNatImpl(NxActionNatBuilder base) {
            this._flags = base.getFlags();
            this._ipAddressMax = base.getIpAddressMax();
            this._ipAddressMin = base.getIpAddressMin();
            this._portMax = base.getPortMax();
            this._portMin = base.getPortMin();
            this._rangePresent = base.getRangePresent();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public java.lang.Integer getFlags() {
            return _flags;
        }
        
        @Override
        public IpAddress getIpAddressMax() {
            return _ipAddressMax;
        }
        
        @Override
        public IpAddress getIpAddressMin() {
            return _ipAddressMin;
        }
        
        @Override
        public java.lang.Integer getPortMax() {
            return _portMax;
        }
        
        @Override
        public java.lang.Integer getPortMin() {
            return _portMin;
        }
        
        @Override
        public java.lang.Integer getRangePresent() {
            return _rangePresent;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_flags);
            result = prime * result + Objects.hashCode(_ipAddressMax);
            result = prime * result + Objects.hashCode(_ipAddressMin);
            result = prime * result + Objects.hashCode(_portMax);
            result = prime * result + Objects.hashCode(_portMin);
            result = prime * result + Objects.hashCode(_rangePresent);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat other = (org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat)obj;
            if (!Objects.equals(_flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(_ipAddressMax, other.getIpAddressMax())) {
                return false;
            }
            if (!Objects.equals(_ipAddressMin, other.getIpAddressMin())) {
                return false;
            }
            if (!Objects.equals(_portMax, other.getPortMax())) {
                return false;
            }
            if (!Objects.equals(_portMin, other.getPortMin())) {
                return false;
            }
            if (!Objects.equals(_rangePresent, other.getRangePresent())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxActionNatImpl otherImpl = (NxActionNatImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.ofpact.actions.ofpact.actions.nx.action.nat._case.NxActionNat>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "NxActionNat [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_flags != null) {
                builder.append("_flags=");
                builder.append(_flags);
                builder.append(", ");
            }
            if (_ipAddressMax != null) {
                builder.append("_ipAddressMax=");
                builder.append(_ipAddressMax);
                builder.append(", ");
            }
            if (_ipAddressMin != null) {
                builder.append("_ipAddressMin=");
                builder.append(_ipAddressMin);
                builder.append(", ");
            }
            if (_portMax != null) {
                builder.append("_portMax=");
                builder.append(_portMax);
                builder.append(", ");
            }
            if (_portMin != null) {
                builder.append("_portMin=");
                builder.append(_portMin);
                builder.append(", ");
            }
            if (_rangePresent != null) {
                builder.append("_rangePresent=");
                builder.append(_rangePresent);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
