package org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.nicira.extension.provider.impl.OpenflowPluginExtensionRegistry;
import org.opendaylight.yangtools.yang.binding.DataObject;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl
 *
 */
public class NiciraExtensionProviderImplBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl> {

    private OpenflowPluginExtensionRegistry _openflowPluginExtensionRegistry;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> augmentation = Collections.emptyMap();

    public NiciraExtensionProviderImplBuilder() {
    }

    public NiciraExtensionProviderImplBuilder(NiciraExtensionProviderImpl base) {
        this._openflowPluginExtensionRegistry = base.getOpenflowPluginExtensionRegistry();
        if (base instanceof NiciraExtensionProviderImplImpl) {
            NiciraExtensionProviderImplImpl impl = (NiciraExtensionProviderImplImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public OpenflowPluginExtensionRegistry getOpenflowPluginExtensionRegistry() {
        return _openflowPluginExtensionRegistry;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public NiciraExtensionProviderImplBuilder setOpenflowPluginExtensionRegistry(final OpenflowPluginExtensionRegistry value) {
        this._openflowPluginExtensionRegistry = value;
        return this;
    }
    
    public NiciraExtensionProviderImplBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NiciraExtensionProviderImplBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NiciraExtensionProviderImpl build() {
        return new NiciraExtensionProviderImplImpl(this);
    }

    private static final class NiciraExtensionProviderImplImpl implements NiciraExtensionProviderImpl {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl.class;
        }

        private final OpenflowPluginExtensionRegistry _openflowPluginExtensionRegistry;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> augmentation = Collections.emptyMap();

        private NiciraExtensionProviderImplImpl(NiciraExtensionProviderImplBuilder base) {
            this._openflowPluginExtensionRegistry = base.getOpenflowPluginExtensionRegistry();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public OpenflowPluginExtensionRegistry getOpenflowPluginExtensionRegistry() {
            return _openflowPluginExtensionRegistry;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_openflowPluginExtensionRegistry);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl other = (org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl)obj;
            if (!Objects.equals(_openflowPluginExtensionRegistry, other.getOpenflowPluginExtensionRegistry())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NiciraExtensionProviderImplImpl otherImpl = (NiciraExtensionProviderImplImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.params.xml.ns.yang.openflowplugin.nx.config.impl.rev140711.modules.module.configuration.NiciraExtensionProviderImpl>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "NiciraExtensionProviderImpl [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_openflowPluginExtensionRegistry != null) {
                builder.append("_openflowPluginExtensionRegistry=");
                builder.append(_openflowPluginExtensionRegistry);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
