package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import java.util.HashMap;
import org.opendaylight.yangtools.concepts.Builder;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import java.util.Collections;
import java.util.Map;

/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath
 *
 */
public class NxMultipathBuilder implements Builder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> {

    private OfjNxMpAlgorithm _algorithm;
    private java.lang.Long _arg;
    private java.lang.Integer _basis;
    private Dst _dst;
    private OfjNxHashFields _fields;
    private java.lang.Integer _maxLink;

    Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> augmentation = Collections.emptyMap();

    public NxMultipathBuilder() {
    }

    public NxMultipathBuilder(NxMultipath base) {
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
        if (base instanceof NxMultipathImpl) {
            NxMultipathImpl impl = (NxMultipathImpl) base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder) {
            @SuppressWarnings("unchecked")
            AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> casted =(AugmentationHolder<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>) base;
            if (!casted.augmentations().isEmpty()) {
                this.augmentation = new HashMap<>(casted.augmentations());
            }
        }
    }


    public OfjNxMpAlgorithm getAlgorithm() {
        return _algorithm;
    }
    
    public java.lang.Long getArg() {
        return _arg;
    }
    
    public java.lang.Integer getBasis() {
        return _basis;
    }
    
    public Dst getDst() {
        return _dst;
    }
    
    public OfjNxHashFields getFields() {
        return _fields;
    }
    
    public java.lang.Integer getMaxLink() {
        return _maxLink;
    }
    
    @SuppressWarnings("unchecked")
    public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> E getAugmentation(java.lang.Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E) augmentation.get(augmentationType);
    }

     
    public NxMultipathBuilder setAlgorithm(final OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }
    
     
     private static void checkArgRange(final long value) {
         if (value >= 0L && value <= 4294967295L) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥4294967295]].", value));
     }
    
    public NxMultipathBuilder setArg(final java.lang.Long value) {
    if (value != null) {
        checkArgRange(value);
    }
        this._arg = value;
        return this;
    }
    
     
     private static void checkBasisRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxMultipathBuilder setBasis(final java.lang.Integer value) {
    if (value != null) {
        checkBasisRange(value);
    }
        this._basis = value;
        return this;
    }
    
     
    public NxMultipathBuilder setDst(final Dst value) {
        this._dst = value;
        return this;
    }
    
     
    public NxMultipathBuilder setFields(final OfjNxHashFields value) {
        this._fields = value;
        return this;
    }
    
     
     private static void checkMaxLinkRange(final int value) {
         if (value >= 0 && value <= 65535) {
             return;
         }
         throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0‥65535]].", value));
     }
    
    public NxMultipathBuilder setMaxLink(final java.lang.Integer value) {
    if (value != null) {
        checkMaxLinkRange(value);
    }
        this._maxLink = value;
        return this;
    }
    
    public NxMultipathBuilder addAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> augmentationType, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> augmentation) {
        if (augmentation == null) {
            return removeAugmentation(augmentationType);
        }
    
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    public NxMultipathBuilder removeAugmentation(java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxMultipath build() {
        return new NxMultipathImpl(this);
    }

    private static final class NxMultipathImpl implements NxMultipath {

        @Override
        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath.class;
        }

        private final OfjNxMpAlgorithm _algorithm;
        private final java.lang.Long _arg;
        private final java.lang.Integer _basis;
        private final Dst _dst;
        private final OfjNxHashFields _fields;
        private final java.lang.Integer _maxLink;

        private Map<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> augmentation = Collections.emptyMap();

        private NxMultipathImpl(NxMultipathBuilder base) {
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
            switch (base.augmentation.size()) {
            case 0:
                this.augmentation = Collections.emptyMap();
                break;
            case 1:
                final Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> e = base.augmentation.entrySet().iterator().next();
                this.augmentation = Collections.<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>singletonMap(e.getKey(), e.getValue());
                break;
            default :
                this.augmentation = new HashMap<>(base.augmentation);
            }
        }

        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return _algorithm;
        }
        
        @Override
        public java.lang.Long getArg() {
            return _arg;
        }
        
        @Override
        public java.lang.Integer getBasis() {
            return _basis;
        }
        
        @Override
        public Dst getDst() {
            return _dst;
        }
        
        @Override
        public OfjNxHashFields getFields() {
            return _fields;
        }
        
        @Override
        public java.lang.Integer getMaxLink() {
            return _maxLink;
        }
        
        @SuppressWarnings("unchecked")
        @Override
        public <E extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> E getAugmentation(java.lang.Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E) augmentation.get(augmentationType);
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_algorithm);
            result = prime * result + Objects.hashCode(_arg);
            result = prime * result + Objects.hashCode(_basis);
            result = prime * result + Objects.hashCode(_dst);
            result = prime * result + Objects.hashCode(_fields);
            result = prime * result + Objects.hashCode(_maxLink);
            result = prime * result + Objects.hashCode(augmentation);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath other = (org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath)obj;
            if (!Objects.equals(_algorithm, other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(_arg, other.getArg())) {
                return false;
            }
            if (!Objects.equals(_basis, other.getBasis())) {
                return false;
            }
            if (!Objects.equals(_dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(_fields, other.getFields())) {
                return false;
            }
            if (!Objects.equals(_maxLink, other.getMaxLink())) {
                return false;
            }
            if (getClass() == obj.getClass()) {
                // Simple case: we are comparing against self
                NxMultipathImpl otherImpl = (NxMultipathImpl) obj;
                if (!Objects.equals(augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                // Hard case: compare our augments with presence there...
                for (Map.Entry<java.lang.Class<? extends Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>>, Augmentation<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>> e : augmentation.entrySet()) {
                    if (!e.getValue().equals(other.getAugmentation(e.getKey()))) {
                        return false;
                    }
                }
                // .. and give the other one the chance to do the same
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.String name = "NxMultipath [";
            java.lang.StringBuilder builder = new java.lang.StringBuilder (name);
            if (_algorithm != null) {
                builder.append("_algorithm=");
                builder.append(_algorithm);
                builder.append(", ");
            }
            if (_arg != null) {
                builder.append("_arg=");
                builder.append(_arg);
                builder.append(", ");
            }
            if (_basis != null) {
                builder.append("_basis=");
                builder.append(_basis);
                builder.append(", ");
            }
            if (_dst != null) {
                builder.append("_dst=");
                builder.append(_dst);
                builder.append(", ");
            }
            if (_fields != null) {
                builder.append("_fields=");
                builder.append(_fields);
                builder.append(", ");
            }
            if (_maxLink != null) {
                builder.append("_maxLink=");
                builder.append(_maxLink);
            }
            final int builderLength = builder.length();
            final int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(augmentation.values());
            return builder.append(']').toString();
        }
    }

}
