package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping;

/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-multipath {
 *     leaf fields {
 *         type ofj-nx-hash-fields;
 *     }
 *     leaf basis {
 *         type basis;
 *     }
 *     leaf algorithm {
 *         type ofj-nx-mp-algorithm;
 *     }
 *     leaf max-link {
 *         type uint16;
 *     }
 *     leaf arg {
 *         type uint32;
 *     }
 *     container dst {
 *         choice dst-choice {
 *             case dst-nx-arp-sha-case {
 *                 leaf nx-arp-sha {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-arp-tha-case {
 *                 leaf nx-arp-tha {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-encap-eth-dst-case {
 *                 leaf nx-encap-eth-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-encap-eth-src-case {
 *                 leaf nx-encap-eth-src {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-ipv6-dst-case {
 *                 leaf nx-ipv6-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-ipv6-src-case {
 *                 leaf nx-ipv6-src {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nsh-mdtype-case {
 *                 leaf nx-nsh-mdtype {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nsh-np-case {
 *                 leaf nx-nsh-np {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nshc-1-case {
 *                 leaf nx-nshc-1-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nshc-2-case {
 *                 leaf nx-nshc-2-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nshc-3-case {
 *                 leaf nx-nshc-3-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nshc-4-case {
 *                 leaf nx-nshc-4-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nsi-case {
 *                 leaf nx-nsi-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-nsp-case {
 *                 leaf nx-nsp-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-of-in-port-case {
 *                 leaf of-in-port {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-reg-case {
 *                 leaf nx-reg {
 *                     type identityref;
 *                 }
 *             }
 *             case dst-nx-tun-gpe-np-case {
 *                 leaf nx-tun-gpe-np {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-tun-id-case {
 *                 leaf nx-tun-id {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-tun-ipv4-dst-case {
 *                 leaf nx-tun-ipv4-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-nx-tun-ipv4-src-case {
 *                 leaf nx-tun-ipv4-src {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-arp-op-case {
 *                 leaf of-arp-op {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-arp-spa-case {
 *                 leaf of-arp-spa {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-arp-tpa-case {
 *                 leaf of-arp-tpa {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-eth-dst-case {
 *                 leaf of-eth-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-eth-src-case {
 *                 leaf of-eth-src {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-icmp-type-case {
 *                 leaf of-icmp-type {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-ip-dst-case {
 *                 leaf of-ip-dst {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-ip-src-case {
 *                 leaf of-ip-src {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-metadata-case {
 *                 leaf of-metadata {
 *                     type empty;
 *                 }
 *             }
 *             case dst-of-mpls-label-case {
 *                 leaf of-mpls-label {
 *                     type empty;
 *                 }
 *             }
 *         }
 *         leaf start {
 *             type uint16;
 *         }
 *         leaf end {
 *             type uint16;
 *         }
 *         uses dst-choice-grouping;
 *         uses range-grouping;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-multipath-grouping/nx-multipath</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipathBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipathBuilder
 *
 */
public interface NxMultipath
    extends
    ChildOf<NxActionMultipathGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-multipath").intern();

    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields</code> <code>fields</code>, or <code>null</code> if not present
     */
    OfjNxHashFields getFields();
    
    /**
     * @return <code>java.lang.Integer</code> <code>basis</code>, or <code>null</code> if not present
     */
    java.lang.Integer getBasis();
    
    /**
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm</code> <code>algorithm</code>, or <code>null</code> if not present
     */
    OfjNxMpAlgorithm getAlgorithm();
    
    /**
     * @return <code>java.lang.Integer</code> <code>maxLink</code>, or <code>null</code> if not present
     */
    java.lang.Integer getMaxLink();
    
    /**
     * @return <code>java.lang.Long</code> <code>arg</code>, or <code>null</code> if not present
     */
    java.lang.Long getArg();
    
    /**
     * Writes value to bits start through end, inclusive, in field dst.
     *
     *
     *
     * @return <code>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst</code> <code>dst</code>, or <code>null</code> if not present
     */
    Dst getDst();

}

