/*
 * Copyright (c) 2015 Cisco Systems, Inc. and others.  All rights reserved.
 *
 * This program and the accompanying materials are made available under the
 * terms of the Eclipse Public License v1.0 which accompanies this distribution,
 * and is available at http://www.eclipse.org/legal/epl-v10.html
 */
package org.opendaylight.openflowplugin.extension.vendor.nicira.convertor.action;

import org.opendaylight.openflowjava.nx.api.NiciraConstants;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.action.grouping.ActionChoice;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.Action;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.action.rev150203.actions.grouping.ActionBuilder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflow.common.types.rev130731.ExperimenterId;

/**
 * @author msunal
 */
public class ActionUtil {

    public final static ExperimenterId EXPERIMENTER_ID = new ExperimenterId(NiciraConstants.NX_VENDOR_ID);

    public static final Action createAction(ActionChoice actionChoice){
        ActionBuilder actionBuilder = new ActionBuilder();
        actionBuilder.setActionChoice(actionChoice);
        actionBuilder.setExperimenterId(EXPERIMENTER_ID);
        return actionBuilder.build();
    }
}
