/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.ietf.params.xml.ns.yang.ietf.inet.types.rev130715.PortNumber;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping.NxmOfUdpSrc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxmOfUdpSrcBuilder
implements Builder<NxmOfUdpSrc> {
    private Integer _mask;
    private PortNumber _port;
    Map<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>> augmentation = Collections.emptyMap();

    public NxmOfUdpSrcBuilder() {
    }

    public NxmOfUdpSrcBuilder(NxmOfUdpSrc base) {
        AugmentationHolder casted;
        this._mask = base.getMask();
        this._port = base.getPort();
        if (base instanceof NxmOfUdpSrcImpl) {
            NxmOfUdpSrcImpl impl = (NxmOfUdpSrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>>(casted.augmentations());
        }
    }

    public Integer getMask() {
        return this._mask;
    }

    public PortNumber getPort() {
        return this._port;
    }

    public <E extends Augmentation<NxmOfUdpSrc>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaskRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxmOfUdpSrcBuilder setMask(Integer value) {
        if (value != null) {
            NxmOfUdpSrcBuilder.checkMaskRange(value);
        }
        this._mask = value;
        return this;
    }

    public NxmOfUdpSrcBuilder setPort(PortNumber value) {
        this._port = value;
        return this;
    }

    public NxmOfUdpSrcBuilder addAugmentation(Class<? extends Augmentation<NxmOfUdpSrc>> augmentationType, Augmentation<NxmOfUdpSrc> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxmOfUdpSrcBuilder removeAugmentation(Class<? extends Augmentation<NxmOfUdpSrc>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxmOfUdpSrc build() {
        return new NxmOfUdpSrcImpl(this);
    }

    private static final class NxmOfUdpSrcImpl
    implements NxmOfUdpSrc {
        private final Integer _mask;
        private final PortNumber _port;
        private Map<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxmOfUdpSrc> getImplementedInterface() {
            return NxmOfUdpSrc.class;
        }

        private NxmOfUdpSrcImpl(NxmOfUdpSrcBuilder base) {
            this._mask = base.getMask();
            this._port = base.getPort();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMask() {
            return this._mask;
        }

        @Override
        public PortNumber getPort() {
            return this._port;
        }

        public <E extends Augmentation<NxmOfUdpSrc>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._mask);
            result = 31 * result + Objects.hashCode(this._port);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxmOfUdpSrc.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxmOfUdpSrc other = (NxmOfUdpSrc)obj;
            if (!Objects.equals(this._mask, other.getMask())) {
                return false;
            }
            if (!Objects.equals(this._port, other.getPort())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxmOfUdpSrcImpl otherImpl = (NxmOfUdpSrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxmOfUdpSrc>>, Augmentation<NxmOfUdpSrc>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxmOfUdpSrc [";
            StringBuilder builder = new StringBuilder(name);
            if (this._mask != null) {
                builder.append("_mask=");
                builder.append(this._mask);
                builder.append(", ");
            }
            if (this._port != null) {
                builder.append("_port=");
                builder.append(this._port);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

