/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxResubmitBuilder
implements Builder<NxResubmit> {
    private Integer _inPort;
    private Short _table;
    Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();

    public NxResubmitBuilder() {
    }

    public NxResubmitBuilder(NxResubmit base) {
        AugmentationHolder casted;
        this._inPort = base.getInPort();
        this._table = base.getTable();
        if (base instanceof NxResubmitImpl) {
            NxResubmitImpl impl = (NxResubmitImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>(casted.augmentations());
        }
    }

    public Integer getInPort() {
        return this._inPort;
    }

    public Short getTable() {
        return this._table;
    }

    public <E extends Augmentation<NxResubmit>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkInPortRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxResubmitBuilder setInPort(Integer value) {
        if (value != null) {
            NxResubmitBuilder.checkInPortRange(value);
        }
        this._inPort = value;
        return this;
    }

    private static void checkTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxResubmitBuilder setTable(Short value) {
        if (value != null) {
            NxResubmitBuilder.checkTableRange(value);
        }
        this._table = value;
        return this;
    }

    public NxResubmitBuilder addAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType, Augmentation<NxResubmit> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxResubmitBuilder removeAugmentation(Class<? extends Augmentation<NxResubmit>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxResubmit build() {
        return new NxResubmitImpl(this);
    }

    private static final class NxResubmitImpl
    implements NxResubmit {
        private final Integer _inPort;
        private final Short _table;
        private Map<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxResubmit> getImplementedInterface() {
            return NxResubmit.class;
        }

        private NxResubmitImpl(NxResubmitBuilder base) {
            this._inPort = base.getInPort();
            this._table = base.getTable();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getInPort() {
            return this._inPort;
        }

        @Override
        public Short getTable() {
            return this._table;
        }

        public <E extends Augmentation<NxResubmit>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._inPort);
            result = 31 * result + Objects.hashCode(this._table);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxResubmit.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxResubmit other = (NxResubmit)obj;
            if (!Objects.equals(this._inPort, other.getInPort())) {
                return false;
            }
            if (!Objects.equals(this._table, other.getTable())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxResubmitImpl otherImpl = (NxResubmitImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxResubmit>>, Augmentation<NxResubmit>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxResubmit [";
            StringBuilder builder = new StringBuilder(name);
            if (this._inPort != null) {
                builder.append("_inPort=");
                builder.append(this._inPort);
                builder.append(", ");
            }
            if (this._table != null) {
                builder.append("_table=");
                builder.append(this._table);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

