/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxActionFinTimeoutBuilder
implements Builder<NxActionFinTimeout> {
    private Integer _finHardTimeout;
    private Integer _finIdleTimeout;
    Map<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> augmentation = Collections.emptyMap();

    public NxActionFinTimeoutBuilder() {
    }

    public NxActionFinTimeoutBuilder(NxActionFinTimeout base) {
        AugmentationHolder casted;
        this._finHardTimeout = base.getFinHardTimeout();
        this._finIdleTimeout = base.getFinIdleTimeout();
        if (base instanceof NxActionFinTimeoutImpl) {
            NxActionFinTimeoutImpl impl = (NxActionFinTimeoutImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>>(casted.augmentations());
        }
    }

    public Integer getFinHardTimeout() {
        return this._finHardTimeout;
    }

    public Integer getFinIdleTimeout() {
        return this._finIdleTimeout;
    }

    public <E extends Augmentation<NxActionFinTimeout>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkFinHardTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionFinTimeoutBuilder setFinHardTimeout(Integer value) {
        if (value != null) {
            NxActionFinTimeoutBuilder.checkFinHardTimeoutRange(value);
        }
        this._finHardTimeout = value;
        return this;
    }

    private static void checkFinIdleTimeoutRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxActionFinTimeoutBuilder setFinIdleTimeout(Integer value) {
        if (value != null) {
            NxActionFinTimeoutBuilder.checkFinIdleTimeoutRange(value);
        }
        this._finIdleTimeout = value;
        return this;
    }

    public NxActionFinTimeoutBuilder addAugmentation(Class<? extends Augmentation<NxActionFinTimeout>> augmentationType, Augmentation<NxActionFinTimeout> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxActionFinTimeoutBuilder removeAugmentation(Class<? extends Augmentation<NxActionFinTimeout>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxActionFinTimeout build() {
        return new NxActionFinTimeoutImpl(this);
    }

    private static final class NxActionFinTimeoutImpl
    implements NxActionFinTimeout {
        private final Integer _finHardTimeout;
        private final Integer _finIdleTimeout;
        private Map<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxActionFinTimeout> getImplementedInterface() {
            return NxActionFinTimeout.class;
        }

        private NxActionFinTimeoutImpl(NxActionFinTimeoutBuilder base) {
            this._finHardTimeout = base.getFinHardTimeout();
            this._finIdleTimeout = base.getFinIdleTimeout();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getFinHardTimeout() {
            return this._finHardTimeout;
        }

        @Override
        public Integer getFinIdleTimeout() {
            return this._finIdleTimeout;
        }

        public <E extends Augmentation<NxActionFinTimeout>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._finHardTimeout);
            result = 31 * result + Objects.hashCode(this._finIdleTimeout);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxActionFinTimeout.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxActionFinTimeout other = (NxActionFinTimeout)obj;
            if (!Objects.equals(this._finHardTimeout, other.getFinHardTimeout())) {
                return false;
            }
            if (!Objects.equals(this._finIdleTimeout, other.getFinIdleTimeout())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxActionFinTimeoutImpl otherImpl = (NxActionFinTimeoutImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxActionFinTimeout>>, Augmentation<NxActionFinTimeout>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxActionFinTimeout [";
            StringBuilder builder = new StringBuilder(name);
            if (this._finHardTimeout != null) {
                builder.append("_finHardTimeout=");
                builder.append(this._finHardTimeout);
                builder.append(", ");
            }
            if (this._finIdleTimeout != null) {
                builder.append("_finIdleTimeout=");
                builder.append(this._finIdleTimeout);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

