/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxConntrackBuilder
implements Builder<NxConntrack> {
    private Integer _conntrackZone;
    private Integer _flags;
    private Short _recircTable;
    private Long _zoneSrc;
    Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> augmentation = Collections.emptyMap();

    public NxConntrackBuilder() {
    }

    public NxConntrackBuilder(NxConntrack base) {
        AugmentationHolder casted;
        this._conntrackZone = base.getConntrackZone();
        this._flags = base.getFlags();
        this._recircTable = base.getRecircTable();
        this._zoneSrc = base.getZoneSrc();
        if (base instanceof NxConntrackImpl) {
            NxConntrackImpl impl = (NxConntrackImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>(casted.augmentations());
        }
    }

    public Integer getConntrackZone() {
        return this._conntrackZone;
    }

    public Integer getFlags() {
        return this._flags;
    }

    public Short getRecircTable() {
        return this._recircTable;
    }

    public Long getZoneSrc() {
        return this._zoneSrc;
    }

    public <E extends Augmentation<NxConntrack>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkConntrackZoneRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxConntrackBuilder setConntrackZone(Integer value) {
        if (value != null) {
            NxConntrackBuilder.checkConntrackZoneRange(value);
        }
        this._conntrackZone = value;
        return this;
    }

    private static void checkFlagsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxConntrackBuilder setFlags(Integer value) {
        if (value != null) {
            NxConntrackBuilder.checkFlagsRange(value);
        }
        this._flags = value;
        return this;
    }

    private static void checkRecircTableRange(short value) {
        if (value >= 0 && value <= 255) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u2025255]].", value));
    }

    public NxConntrackBuilder setRecircTable(Short value) {
        if (value != null) {
            NxConntrackBuilder.checkRecircTableRange(value);
        }
        this._recircTable = value;
        return this;
    }

    private static void checkZoneSrcRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxConntrackBuilder setZoneSrc(Long value) {
        if (value != null) {
            NxConntrackBuilder.checkZoneSrcRange(value);
        }
        this._zoneSrc = value;
        return this;
    }

    public NxConntrackBuilder addAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType, Augmentation<NxConntrack> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxConntrackBuilder removeAugmentation(Class<? extends Augmentation<NxConntrack>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxConntrack build() {
        return new NxConntrackImpl(this);
    }

    private static final class NxConntrackImpl
    implements NxConntrack {
        private final Integer _conntrackZone;
        private final Integer _flags;
        private final Short _recircTable;
        private final Long _zoneSrc;
        private Map<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxConntrack> getImplementedInterface() {
            return NxConntrack.class;
        }

        private NxConntrackImpl(NxConntrackBuilder base) {
            this._conntrackZone = base.getConntrackZone();
            this._flags = base.getFlags();
            this._recircTable = base.getRecircTable();
            this._zoneSrc = base.getZoneSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getConntrackZone() {
            return this._conntrackZone;
        }

        @Override
        public Integer getFlags() {
            return this._flags;
        }

        @Override
        public Short getRecircTable() {
            return this._recircTable;
        }

        @Override
        public Long getZoneSrc() {
            return this._zoneSrc;
        }

        public <E extends Augmentation<NxConntrack>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._conntrackZone);
            result = 31 * result + Objects.hashCode(this._flags);
            result = 31 * result + Objects.hashCode(this._recircTable);
            result = 31 * result + Objects.hashCode(this._zoneSrc);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxConntrack.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxConntrack other = (NxConntrack)obj;
            if (!Objects.equals(this._conntrackZone, other.getConntrackZone())) {
                return false;
            }
            if (!Objects.equals(this._flags, other.getFlags())) {
                return false;
            }
            if (!Objects.equals(this._recircTable, other.getRecircTable())) {
                return false;
            }
            if (!Objects.equals(this._zoneSrc, other.getZoneSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxConntrackImpl otherImpl = (NxConntrackImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxConntrack>>, Augmentation<NxConntrack>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            String name = "NxConntrack [";
            StringBuilder builder = new StringBuilder(name);
            if (this._conntrackZone != null) {
                builder.append("_conntrackZone=");
                builder.append(this._conntrackZone);
                builder.append(", ");
            }
            if (this._flags != null) {
                builder.append("_flags=");
                builder.append(this._flags);
                builder.append(", ");
            }
            if (this._recircTable != null) {
                builder.append("_recircTable=");
                builder.append(this._recircTable);
                builder.append(", ");
            }
            if (this._zoneSrc != null) {
                builder.append("_zoneSrc=");
                builder.append(this._zoneSrc);
            }
            int builderLength = builder.length();
            int builderAdditionalLength = builder.substring(name.length(), builderLength).length();
            if (builderAdditionalLength > 2 && !builder.substring(builderLength - 2, builderLength).equals(", ")) {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

