package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionResubmitGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * Re-searches OpenFlow flow table (or the table whose number is specified by 
 * table) with the in-port field replaced by port (if port is specified) and 
 * executes the actions found
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-resubmit {
 *     leaf in-port {
 *         type in-port;
 *     }
 *     leaf table {
 *         type table;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-resubmit-grouping/nx-resubmit</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmitBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmitBuilder
 *
 */
public interface NxResubmit
    extends
    ChildOf<NxActionResubmitGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.resubmit.grouping.NxResubmit>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-resubmit").intern();

    /**
     * @return <code>java.lang.Integer</code> <code>inPort</code>, or <code>null</code> if not present
     */
    java.lang.Integer getInPort();
    
    /**
     * @return <code>java.lang.Short</code> <code>table</code>, or <code>null</code> if not present
     */
    java.lang.Short getTable();

}

