/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxOutputRegBuilder
implements Builder<NxOutputReg> {
    private Integer _maxLen;
    private Src _src;
    Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = Collections.emptyMap();

    public NxOutputRegBuilder() {
    }

    public NxOutputRegBuilder(NxOutputReg base) {
        AugmentationHolder casted;
        this._maxLen = base.getMaxLen();
        this._src = base.getSrc();
        if (base instanceof NxOutputRegImpl) {
            NxOutputRegImpl impl = (NxOutputRegImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(casted.augmentations());
        }
    }

    public Integer getMaxLen() {
        return this._maxLen;
    }

    public Src getSrc() {
        return this._src;
    }

    public <E extends Augmentation<NxOutputReg>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkMaxLenRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxOutputRegBuilder setMaxLen(Integer value) {
        if (value != null) {
            NxOutputRegBuilder.checkMaxLenRange(value);
        }
        this._maxLen = value;
        return this;
    }

    public NxOutputRegBuilder setSrc(Src value) {
        this._src = value;
        return this;
    }

    public NxOutputRegBuilder addAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType, Augmentation<NxOutputReg> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxOutputRegBuilder removeAugmentation(Class<? extends Augmentation<NxOutputReg>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxOutputReg build() {
        return new NxOutputRegImpl(this);
    }

    private static final class NxOutputRegImpl
    implements NxOutputReg {
        private final Integer _maxLen;
        private final Src _src;
        private Map<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxOutputReg> getImplementedInterface() {
            return NxOutputReg.class;
        }

        private NxOutputRegImpl(NxOutputRegBuilder base) {
            this._maxLen = base.getMaxLen();
            this._src = base.getSrc();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getMaxLen() {
            return this._maxLen;
        }

        @Override
        public Src getSrc() {
            return this._src;
        }

        public <E extends Augmentation<NxOutputReg>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._maxLen);
            result = 31 * result + Objects.hashCode(this._src);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxOutputReg.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxOutputReg other = (NxOutputReg)obj;
            if (!Objects.equals(this._maxLen, other.getMaxLen())) {
                return false;
            }
            if (!Objects.equals(this._src, other.getSrc())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxOutputRegImpl otherImpl = (NxOutputRegImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxOutputReg>>, Augmentation<NxOutputReg>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxOutputReg [");
            boolean first = true;
            if (this._maxLen != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLen=");
                builder.append(this._maxLen);
            }
            if (this._src != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_src=");
                builder.append(this._src);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

