package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.Ipv4AddressGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * Prereqs: NXM_OF_ETH_TYPE must match either 0x0806 or 0x8035.
 *
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <br>(Source path: <i>META-INF/yang/openflowplugin-extension-nicira-match.yang</i>):
 * <pre>
 * container nxm-of-arp-tpa {
 *     leaf ipv4-address {
 *         type ipv4-address;
 *     }
 *     uses ipv4-address-grouping;
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-match/nxm-of-arp-tpa-grouping/nxm-of-arp-tpa</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping.NxmOfArpTpaBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping.NxmOfArpTpaBuilder
 *
 */
public interface NxmOfArpTpa
    extends
    ChildOf<NxmOfArpTpaGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping.NxmOfArpTpa>,
    Ipv4AddressGrouping
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:match",
        "2014-07-14", "nxm-of-arp-tpa").intern();


}

