package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.id.grouping.NxmNxTunId;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.type.grouping.NxmOfEthType;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.ipv4.src.grouping.NxmNxTunIpv4Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.src.grouping.NxmOfUdpSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.src.grouping.NxmOfEthSrc;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.op.grouping.NxmOfArpOp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.ip.dst.grouping.NxmOfIpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.ip.src.grouping.NxmOfIpSrc;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.eth.dst.grouping.NxmOfEthDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.udp.dst.grouping.NxmOfUdpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.tun.ipv4.dst.grouping.NxmNxTunIpv4Dst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsp.grouping.NxmNxNsp;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.tcp.dst.grouping.NxmOfTcpDst;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._3.grouping.NxmNxNshc3;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.arp.sha.grouping.NxmNxArpSha;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nsi.grouping.NxmNxNsi;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._4.grouping.NxmNxNshc4;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.tpa.grouping.NxmOfArpTpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._1.grouping.NxmNxNshc1;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.state.grouping.NxmNxCtState;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.arp.spa.grouping.NxmOfArpSpa;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.nshc._2.grouping.NxmNxNshc2;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.icmp.type.grouping.NxmOfIcmpType;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.of.tcp.src.grouping.NxmOfTcpSrc;
import org.opendaylight.yangtools.yang.binding.DataObject;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.ct.zone.grouping.NxmNxCtZone;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.arp.tha.grouping.NxmNxArpTha;


/**
 * Class that builds {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow} instances.
 *
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow
 *
 */
public class NxAugMatchRpcRemoveFlowBuilder implements Builder <org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow> {

    private NxmNxArpSha _nxmNxArpSha;
    private NxmNxArpTha _nxmNxArpTha;
    private NxmNxCtState _nxmNxCtState;
    private NxmNxCtZone _nxmNxCtZone;
    private NxmNxNshc1 _nxmNxNshc1;
    private NxmNxNshc2 _nxmNxNshc2;
    private NxmNxNshc3 _nxmNxNshc3;
    private NxmNxNshc4 _nxmNxNshc4;
    private NxmNxNsi _nxmNxNsi;
    private NxmNxNsp _nxmNxNsp;
    private NxmNxReg _nxmNxReg;
    private NxmNxTunId _nxmNxTunId;
    private NxmNxTunIpv4Dst _nxmNxTunIpv4Dst;
    private NxmNxTunIpv4Src _nxmNxTunIpv4Src;
    private NxmOfArpOp _nxmOfArpOp;
    private NxmOfArpSpa _nxmOfArpSpa;
    private NxmOfArpTpa _nxmOfArpTpa;
    private NxmOfEthDst _nxmOfEthDst;
    private NxmOfEthSrc _nxmOfEthSrc;
    private NxmOfEthType _nxmOfEthType;
    private NxmOfIcmpType _nxmOfIcmpType;
    private NxmOfIpDst _nxmOfIpDst;
    private NxmOfIpSrc _nxmOfIpSrc;
    private NxmOfTcpDst _nxmOfTcpDst;
    private NxmOfTcpSrc _nxmOfTcpSrc;
    private NxmOfUdpDst _nxmOfUdpDst;
    private NxmOfUdpSrc _nxmOfUdpSrc;


    public NxAugMatchRpcRemoveFlowBuilder() {
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping arg) {
        this._nxmNxCtZone = arg.getNxmNxCtZone();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping arg) {
        this._nxmOfIpSrc = arg.getNxmOfIpSrc();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping arg) {
        this._nxmOfEthDst = arg.getNxmOfEthDst();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping arg) {
        this._nxmNxNshc2 = arg.getNxmNxNshc2();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping arg) {
        this._nxmNxTunIpv4Dst = arg.getNxmNxTunIpv4Dst();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping arg) {
        this._nxmOfEthType = arg.getNxmOfEthType();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping arg) {
        this._nxmNxArpTha = arg.getNxmNxArpTha();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping arg) {
        this._nxmNxReg = arg.getNxmNxReg();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping arg) {
        this._nxmNxNshc1 = arg.getNxmNxNshc1();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping arg) {
        this._nxmOfIcmpType = arg.getNxmOfIcmpType();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping arg) {
        this._nxmNxNshc4 = arg.getNxmNxNshc4();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping arg) {
        this._nxmOfEthSrc = arg.getNxmOfEthSrc();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping arg) {
        this._nxmNxTunIpv4Src = arg.getNxmNxTunIpv4Src();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping arg) {
        this._nxmOfTcpSrc = arg.getNxmOfTcpSrc();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping arg) {
        this._nxmNxTunId = arg.getNxmNxTunId();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping arg) {
        this._nxmNxArpSha = arg.getNxmNxArpSha();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping arg) {
        this._nxmNxCtState = arg.getNxmNxCtState();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping arg) {
        this._nxmNxNsi = arg.getNxmNxNsi();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping arg) {
        this._nxmOfArpOp = arg.getNxmOfArpOp();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping arg) {
        this._nxmOfIpDst = arg.getNxmOfIpDst();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping arg) {
        this._nxmOfArpTpa = arg.getNxmOfArpTpa();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping arg) {
        this._nxmNxNshc3 = arg.getNxmNxNshc3();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping arg) {
        this._nxmOfUdpSrc = arg.getNxmOfUdpSrc();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping arg) {
        this._nxmOfArpSpa = arg.getNxmOfArpSpa();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping arg) {
        this._nxmOfUdpDst = arg.getNxmOfUdpDst();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping arg) {
        this._nxmOfTcpDst = arg.getNxmOfTcpDst();
    }
    public NxAugMatchRpcRemoveFlowBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping arg) {
        this._nxmNxNsp = arg.getNxmNxNsp();
    }

    public NxAugMatchRpcRemoveFlowBuilder(NxAugMatchRpcRemoveFlow base) {
        this._nxmNxArpSha = base.getNxmNxArpSha();
        this._nxmNxArpTha = base.getNxmNxArpTha();
        this._nxmNxCtState = base.getNxmNxCtState();
        this._nxmNxCtZone = base.getNxmNxCtZone();
        this._nxmNxNshc1 = base.getNxmNxNshc1();
        this._nxmNxNshc2 = base.getNxmNxNshc2();
        this._nxmNxNshc3 = base.getNxmNxNshc3();
        this._nxmNxNshc4 = base.getNxmNxNshc4();
        this._nxmNxNsi = base.getNxmNxNsi();
        this._nxmNxNsp = base.getNxmNxNsp();
        this._nxmNxReg = base.getNxmNxReg();
        this._nxmNxTunId = base.getNxmNxTunId();
        this._nxmNxTunIpv4Dst = base.getNxmNxTunIpv4Dst();
        this._nxmNxTunIpv4Src = base.getNxmNxTunIpv4Src();
        this._nxmOfArpOp = base.getNxmOfArpOp();
        this._nxmOfArpSpa = base.getNxmOfArpSpa();
        this._nxmOfArpTpa = base.getNxmOfArpTpa();
        this._nxmOfEthDst = base.getNxmOfEthDst();
        this._nxmOfEthSrc = base.getNxmOfEthSrc();
        this._nxmOfEthType = base.getNxmOfEthType();
        this._nxmOfIcmpType = base.getNxmOfIcmpType();
        this._nxmOfIpDst = base.getNxmOfIpDst();
        this._nxmOfIpSrc = base.getNxmOfIpSrc();
        this._nxmOfTcpDst = base.getNxmOfTcpDst();
        this._nxmOfTcpSrc = base.getNxmOfTcpSrc();
        this._nxmOfUdpDst = base.getNxmOfUdpDst();
        this._nxmOfUdpSrc = base.getNxmOfUdpSrc();
    }

    /**
     *Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping</li>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping) {
            this._nxmNxNsp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping)arg).getNxmNxNsp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping) {
            this._nxmNxCtState = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping)arg).getNxmNxCtState();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping) {
            this._nxmOfIpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping)arg).getNxmOfIpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping) {
            this._nxmOfUdpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping)arg).getNxmOfUdpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping) {
            this._nxmOfArpOp = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping)arg).getNxmOfArpOp();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping) {
            this._nxmNxCtZone = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping)arg).getNxmNxCtZone();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping) {
            this._nxmNxNshc3 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping)arg).getNxmNxNshc3();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping) {
            this._nxmNxNsi = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping)arg).getNxmNxNsi();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping) {
            this._nxmNxTunIpv4Src = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping)arg).getNxmNxTunIpv4Src();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping) {
            this._nxmOfArpSpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping)arg).getNxmOfArpSpa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping) {
            this._nxmNxArpSha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping)arg).getNxmNxArpSha();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping) {
            this._nxmOfEthDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping)arg).getNxmOfEthDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping) {
            this._nxmNxArpTha = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping)arg).getNxmNxArpTha();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping) {
            this._nxmOfIcmpType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping)arg).getNxmOfIcmpType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping) {
            this._nxmNxReg = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping)arg).getNxmNxReg();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping) {
            this._nxmOfTcpDst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping)arg).getNxmOfTcpDst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping) {
            this._nxmOfUdpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping)arg).getNxmOfUdpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping) {
            this._nxmNxTunId = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping)arg).getNxmNxTunId();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping) {
            this._nxmNxNshc2 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping)arg).getNxmNxNshc2();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping) {
            this._nxmNxTunIpv4Dst = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping)arg).getNxmNxTunIpv4Dst();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping) {
            this._nxmOfTcpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping)arg).getNxmOfTcpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping) {
            this._nxmOfArpTpa = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping)arg).getNxmOfArpTpa();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping) {
            this._nxmOfEthSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping)arg).getNxmOfEthSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping) {
            this._nxmNxNshc4 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping)arg).getNxmNxNshc4();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping) {
            this._nxmOfEthType = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping)arg).getNxmOfEthType();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping) {
            this._nxmOfIpSrc = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping)arg).getNxmOfIpSrc();
            isValidArg = true;
        }
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping) {
            this._nxmNxNshc1 = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping)arg).getNxmNxNshc1();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException(
              "expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNspGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtStateGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpOpGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxCtZoneGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc3Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNsiGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4SrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpSpaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpShaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxArpThaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIcmpTypeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpDstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfUdpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIdGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc2Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxTunIpv4DstGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfTcpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfArpTpaGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc4Grouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfEthTypeGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmOfIpSrcGrouping, org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxNshc1Grouping] \n" +
              "but was: " + arg
            );
        }
    }

    public NxmNxArpSha getNxmNxArpSha() {
        return _nxmNxArpSha;
    }
    
    public NxmNxArpTha getNxmNxArpTha() {
        return _nxmNxArpTha;
    }
    
    public NxmNxCtState getNxmNxCtState() {
        return _nxmNxCtState;
    }
    
    public NxmNxCtZone getNxmNxCtZone() {
        return _nxmNxCtZone;
    }
    
    public NxmNxNshc1 getNxmNxNshc1() {
        return _nxmNxNshc1;
    }
    
    public NxmNxNshc2 getNxmNxNshc2() {
        return _nxmNxNshc2;
    }
    
    public NxmNxNshc3 getNxmNxNshc3() {
        return _nxmNxNshc3;
    }
    
    public NxmNxNshc4 getNxmNxNshc4() {
        return _nxmNxNshc4;
    }
    
    public NxmNxNsi getNxmNxNsi() {
        return _nxmNxNsi;
    }
    
    public NxmNxNsp getNxmNxNsp() {
        return _nxmNxNsp;
    }
    
    public NxmNxReg getNxmNxReg() {
        return _nxmNxReg;
    }
    
    public NxmNxTunId getNxmNxTunId() {
        return _nxmNxTunId;
    }
    
    public NxmNxTunIpv4Dst getNxmNxTunIpv4Dst() {
        return _nxmNxTunIpv4Dst;
    }
    
    public NxmNxTunIpv4Src getNxmNxTunIpv4Src() {
        return _nxmNxTunIpv4Src;
    }
    
    public NxmOfArpOp getNxmOfArpOp() {
        return _nxmOfArpOp;
    }
    
    public NxmOfArpSpa getNxmOfArpSpa() {
        return _nxmOfArpSpa;
    }
    
    public NxmOfArpTpa getNxmOfArpTpa() {
        return _nxmOfArpTpa;
    }
    
    public NxmOfEthDst getNxmOfEthDst() {
        return _nxmOfEthDst;
    }
    
    public NxmOfEthSrc getNxmOfEthSrc() {
        return _nxmOfEthSrc;
    }
    
    public NxmOfEthType getNxmOfEthType() {
        return _nxmOfEthType;
    }
    
    public NxmOfIcmpType getNxmOfIcmpType() {
        return _nxmOfIcmpType;
    }
    
    public NxmOfIpDst getNxmOfIpDst() {
        return _nxmOfIpDst;
    }
    
    public NxmOfIpSrc getNxmOfIpSrc() {
        return _nxmOfIpSrc;
    }
    
    public NxmOfTcpDst getNxmOfTcpDst() {
        return _nxmOfTcpDst;
    }
    
    public NxmOfTcpSrc getNxmOfTcpSrc() {
        return _nxmOfTcpSrc;
    }
    
    public NxmOfUdpDst getNxmOfUdpDst() {
        return _nxmOfUdpDst;
    }
    
    public NxmOfUdpSrc getNxmOfUdpSrc() {
        return _nxmOfUdpSrc;
    }

     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxArpSha(final NxmNxArpSha value) {
        this._nxmNxArpSha = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxArpTha(final NxmNxArpTha value) {
        this._nxmNxArpTha = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxCtState(final NxmNxCtState value) {
        this._nxmNxCtState = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxCtZone(final NxmNxCtZone value) {
        this._nxmNxCtZone = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNshc1(final NxmNxNshc1 value) {
        this._nxmNxNshc1 = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNshc2(final NxmNxNshc2 value) {
        this._nxmNxNshc2 = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNshc3(final NxmNxNshc3 value) {
        this._nxmNxNshc3 = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNshc4(final NxmNxNshc4 value) {
        this._nxmNxNshc4 = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNsi(final NxmNxNsi value) {
        this._nxmNxNsi = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxNsp(final NxmNxNsp value) {
        this._nxmNxNsp = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxReg(final NxmNxReg value) {
        this._nxmNxReg = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxTunId(final NxmNxTunId value) {
        this._nxmNxTunId = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxTunIpv4Dst(final NxmNxTunIpv4Dst value) {
        this._nxmNxTunIpv4Dst = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmNxTunIpv4Src(final NxmNxTunIpv4Src value) {
        this._nxmNxTunIpv4Src = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfArpOp(final NxmOfArpOp value) {
        this._nxmOfArpOp = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfArpSpa(final NxmOfArpSpa value) {
        this._nxmOfArpSpa = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfArpTpa(final NxmOfArpTpa value) {
        this._nxmOfArpTpa = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfEthDst(final NxmOfEthDst value) {
        this._nxmOfEthDst = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfEthSrc(final NxmOfEthSrc value) {
        this._nxmOfEthSrc = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfEthType(final NxmOfEthType value) {
        this._nxmOfEthType = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfIcmpType(final NxmOfIcmpType value) {
        this._nxmOfIcmpType = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfIpDst(final NxmOfIpDst value) {
        this._nxmOfIpDst = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfIpSrc(final NxmOfIpSrc value) {
        this._nxmOfIpSrc = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfTcpDst(final NxmOfTcpDst value) {
        this._nxmOfTcpDst = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfTcpSrc(final NxmOfTcpSrc value) {
        this._nxmOfTcpSrc = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfUdpDst(final NxmOfUdpDst value) {
        this._nxmOfUdpDst = value;
        return this;
    }
    
     
    public NxAugMatchRpcRemoveFlowBuilder setNxmOfUdpSrc(final NxmOfUdpSrc value) {
        this._nxmOfUdpSrc = value;
        return this;
    }

    public NxAugMatchRpcRemoveFlow build() {
        return new NxAugMatchRpcRemoveFlowImpl(this);
    }

    private static final class NxAugMatchRpcRemoveFlowImpl implements NxAugMatchRpcRemoveFlow {

        public java.lang.Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow> getImplementedInterface() {
            return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow.class;
        }

        private final NxmNxArpSha _nxmNxArpSha;
        private final NxmNxArpTha _nxmNxArpTha;
        private final NxmNxCtState _nxmNxCtState;
        private final NxmNxCtZone _nxmNxCtZone;
        private final NxmNxNshc1 _nxmNxNshc1;
        private final NxmNxNshc2 _nxmNxNshc2;
        private final NxmNxNshc3 _nxmNxNshc3;
        private final NxmNxNshc4 _nxmNxNshc4;
        private final NxmNxNsi _nxmNxNsi;
        private final NxmNxNsp _nxmNxNsp;
        private final NxmNxReg _nxmNxReg;
        private final NxmNxTunId _nxmNxTunId;
        private final NxmNxTunIpv4Dst _nxmNxTunIpv4Dst;
        private final NxmNxTunIpv4Src _nxmNxTunIpv4Src;
        private final NxmOfArpOp _nxmOfArpOp;
        private final NxmOfArpSpa _nxmOfArpSpa;
        private final NxmOfArpTpa _nxmOfArpTpa;
        private final NxmOfEthDst _nxmOfEthDst;
        private final NxmOfEthSrc _nxmOfEthSrc;
        private final NxmOfEthType _nxmOfEthType;
        private final NxmOfIcmpType _nxmOfIcmpType;
        private final NxmOfIpDst _nxmOfIpDst;
        private final NxmOfIpSrc _nxmOfIpSrc;
        private final NxmOfTcpDst _nxmOfTcpDst;
        private final NxmOfTcpSrc _nxmOfTcpSrc;
        private final NxmOfUdpDst _nxmOfUdpDst;
        private final NxmOfUdpSrc _nxmOfUdpSrc;


        private NxAugMatchRpcRemoveFlowImpl(NxAugMatchRpcRemoveFlowBuilder base) {
            this._nxmNxArpSha = base.getNxmNxArpSha();
            this._nxmNxArpTha = base.getNxmNxArpTha();
            this._nxmNxCtState = base.getNxmNxCtState();
            this._nxmNxCtZone = base.getNxmNxCtZone();
            this._nxmNxNshc1 = base.getNxmNxNshc1();
            this._nxmNxNshc2 = base.getNxmNxNshc2();
            this._nxmNxNshc3 = base.getNxmNxNshc3();
            this._nxmNxNshc4 = base.getNxmNxNshc4();
            this._nxmNxNsi = base.getNxmNxNsi();
            this._nxmNxNsp = base.getNxmNxNsp();
            this._nxmNxReg = base.getNxmNxReg();
            this._nxmNxTunId = base.getNxmNxTunId();
            this._nxmNxTunIpv4Dst = base.getNxmNxTunIpv4Dst();
            this._nxmNxTunIpv4Src = base.getNxmNxTunIpv4Src();
            this._nxmOfArpOp = base.getNxmOfArpOp();
            this._nxmOfArpSpa = base.getNxmOfArpSpa();
            this._nxmOfArpTpa = base.getNxmOfArpTpa();
            this._nxmOfEthDst = base.getNxmOfEthDst();
            this._nxmOfEthSrc = base.getNxmOfEthSrc();
            this._nxmOfEthType = base.getNxmOfEthType();
            this._nxmOfIcmpType = base.getNxmOfIcmpType();
            this._nxmOfIpDst = base.getNxmOfIpDst();
            this._nxmOfIpSrc = base.getNxmOfIpSrc();
            this._nxmOfTcpDst = base.getNxmOfTcpDst();
            this._nxmOfTcpSrc = base.getNxmOfTcpSrc();
            this._nxmOfUdpDst = base.getNxmOfUdpDst();
            this._nxmOfUdpSrc = base.getNxmOfUdpSrc();
        }

        @Override
        public NxmNxArpSha getNxmNxArpSha() {
            return _nxmNxArpSha;
        }
        
        @Override
        public NxmNxArpTha getNxmNxArpTha() {
            return _nxmNxArpTha;
        }
        
        @Override
        public NxmNxCtState getNxmNxCtState() {
            return _nxmNxCtState;
        }
        
        @Override
        public NxmNxCtZone getNxmNxCtZone() {
            return _nxmNxCtZone;
        }
        
        @Override
        public NxmNxNshc1 getNxmNxNshc1() {
            return _nxmNxNshc1;
        }
        
        @Override
        public NxmNxNshc2 getNxmNxNshc2() {
            return _nxmNxNshc2;
        }
        
        @Override
        public NxmNxNshc3 getNxmNxNshc3() {
            return _nxmNxNshc3;
        }
        
        @Override
        public NxmNxNshc4 getNxmNxNshc4() {
            return _nxmNxNshc4;
        }
        
        @Override
        public NxmNxNsi getNxmNxNsi() {
            return _nxmNxNsi;
        }
        
        @Override
        public NxmNxNsp getNxmNxNsp() {
            return _nxmNxNsp;
        }
        
        @Override
        public NxmNxReg getNxmNxReg() {
            return _nxmNxReg;
        }
        
        @Override
        public NxmNxTunId getNxmNxTunId() {
            return _nxmNxTunId;
        }
        
        @Override
        public NxmNxTunIpv4Dst getNxmNxTunIpv4Dst() {
            return _nxmNxTunIpv4Dst;
        }
        
        @Override
        public NxmNxTunIpv4Src getNxmNxTunIpv4Src() {
            return _nxmNxTunIpv4Src;
        }
        
        @Override
        public NxmOfArpOp getNxmOfArpOp() {
            return _nxmOfArpOp;
        }
        
        @Override
        public NxmOfArpSpa getNxmOfArpSpa() {
            return _nxmOfArpSpa;
        }
        
        @Override
        public NxmOfArpTpa getNxmOfArpTpa() {
            return _nxmOfArpTpa;
        }
        
        @Override
        public NxmOfEthDst getNxmOfEthDst() {
            return _nxmOfEthDst;
        }
        
        @Override
        public NxmOfEthSrc getNxmOfEthSrc() {
            return _nxmOfEthSrc;
        }
        
        @Override
        public NxmOfEthType getNxmOfEthType() {
            return _nxmOfEthType;
        }
        
        @Override
        public NxmOfIcmpType getNxmOfIcmpType() {
            return _nxmOfIcmpType;
        }
        
        @Override
        public NxmOfIpDst getNxmOfIpDst() {
            return _nxmOfIpDst;
        }
        
        @Override
        public NxmOfIpSrc getNxmOfIpSrc() {
            return _nxmOfIpSrc;
        }
        
        @Override
        public NxmOfTcpDst getNxmOfTcpDst() {
            return _nxmOfTcpDst;
        }
        
        @Override
        public NxmOfTcpSrc getNxmOfTcpSrc() {
            return _nxmOfTcpSrc;
        }
        
        @Override
        public NxmOfUdpDst getNxmOfUdpDst() {
            return _nxmOfUdpDst;
        }
        
        @Override
        public NxmOfUdpSrc getNxmOfUdpSrc() {
            return _nxmOfUdpSrc;
        }

        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int prime = 31;
            int result = 1;
            result = prime * result + Objects.hashCode(_nxmNxArpSha);
            result = prime * result + Objects.hashCode(_nxmNxArpTha);
            result = prime * result + Objects.hashCode(_nxmNxCtState);
            result = prime * result + Objects.hashCode(_nxmNxCtZone);
            result = prime * result + Objects.hashCode(_nxmNxNshc1);
            result = prime * result + Objects.hashCode(_nxmNxNshc2);
            result = prime * result + Objects.hashCode(_nxmNxNshc3);
            result = prime * result + Objects.hashCode(_nxmNxNshc4);
            result = prime * result + Objects.hashCode(_nxmNxNsi);
            result = prime * result + Objects.hashCode(_nxmNxNsp);
            result = prime * result + Objects.hashCode(_nxmNxReg);
            result = prime * result + Objects.hashCode(_nxmNxTunId);
            result = prime * result + Objects.hashCode(_nxmNxTunIpv4Dst);
            result = prime * result + Objects.hashCode(_nxmNxTunIpv4Src);
            result = prime * result + Objects.hashCode(_nxmOfArpOp);
            result = prime * result + Objects.hashCode(_nxmOfArpSpa);
            result = prime * result + Objects.hashCode(_nxmOfArpTpa);
            result = prime * result + Objects.hashCode(_nxmOfEthDst);
            result = prime * result + Objects.hashCode(_nxmOfEthSrc);
            result = prime * result + Objects.hashCode(_nxmOfEthType);
            result = prime * result + Objects.hashCode(_nxmOfIcmpType);
            result = prime * result + Objects.hashCode(_nxmOfIpDst);
            result = prime * result + Objects.hashCode(_nxmOfIpSrc);
            result = prime * result + Objects.hashCode(_nxmOfTcpDst);
            result = prime * result + Objects.hashCode(_nxmOfTcpSrc);
            result = prime * result + Objects.hashCode(_nxmOfUdpDst);
            result = prime * result + Objects.hashCode(_nxmOfUdpSrc);
        
            hash = result;
            hashValid = true;
            return result;
        }

        @Override
        public boolean equals(java.lang.Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow.class.equals(((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow other = (org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxAugMatchRpcRemoveFlow)obj;
            if (!Objects.equals(_nxmNxArpSha, other.getNxmNxArpSha())) {
                return false;
            }
            if (!Objects.equals(_nxmNxArpTha, other.getNxmNxArpTha())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtState, other.getNxmNxCtState())) {
                return false;
            }
            if (!Objects.equals(_nxmNxCtZone, other.getNxmNxCtZone())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc1, other.getNxmNxNshc1())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc2, other.getNxmNxNshc2())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc3, other.getNxmNxNshc3())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNshc4, other.getNxmNxNshc4())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNsi, other.getNxmNxNsi())) {
                return false;
            }
            if (!Objects.equals(_nxmNxNsp, other.getNxmNxNsp())) {
                return false;
            }
            if (!Objects.equals(_nxmNxReg, other.getNxmNxReg())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunId, other.getNxmNxTunId())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunIpv4Dst, other.getNxmNxTunIpv4Dst())) {
                return false;
            }
            if (!Objects.equals(_nxmNxTunIpv4Src, other.getNxmNxTunIpv4Src())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpOp, other.getNxmOfArpOp())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpSpa, other.getNxmOfArpSpa())) {
                return false;
            }
            if (!Objects.equals(_nxmOfArpTpa, other.getNxmOfArpTpa())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthDst, other.getNxmOfEthDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthSrc, other.getNxmOfEthSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfEthType, other.getNxmOfEthType())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIcmpType, other.getNxmOfIcmpType())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIpDst, other.getNxmOfIpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfIpSrc, other.getNxmOfIpSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfTcpDst, other.getNxmOfTcpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfTcpSrc, other.getNxmOfTcpSrc())) {
                return false;
            }
            if (!Objects.equals(_nxmOfUdpDst, other.getNxmOfUdpDst())) {
                return false;
            }
            if (!Objects.equals(_nxmOfUdpSrc, other.getNxmOfUdpSrc())) {
                return false;
            }
            return true;
        }

        @Override
        public java.lang.String toString() {
            java.lang.StringBuilder builder = new java.lang.StringBuilder ("NxAugMatchRpcRemoveFlow [");
            boolean first = true;
        
            if (_nxmNxArpSha != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxArpSha=");
                builder.append(_nxmNxArpSha);
             }
            if (_nxmNxArpTha != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxArpTha=");
                builder.append(_nxmNxArpTha);
             }
            if (_nxmNxCtState != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxCtState=");
                builder.append(_nxmNxCtState);
             }
            if (_nxmNxCtZone != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxCtZone=");
                builder.append(_nxmNxCtZone);
             }
            if (_nxmNxNshc1 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNshc1=");
                builder.append(_nxmNxNshc1);
             }
            if (_nxmNxNshc2 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNshc2=");
                builder.append(_nxmNxNshc2);
             }
            if (_nxmNxNshc3 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNshc3=");
                builder.append(_nxmNxNshc3);
             }
            if (_nxmNxNshc4 != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNshc4=");
                builder.append(_nxmNxNshc4);
             }
            if (_nxmNxNsi != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNsi=");
                builder.append(_nxmNxNsi);
             }
            if (_nxmNxNsp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxNsp=");
                builder.append(_nxmNxNsp);
             }
            if (_nxmNxReg != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxReg=");
                builder.append(_nxmNxReg);
             }
            if (_nxmNxTunId != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxTunId=");
                builder.append(_nxmNxTunId);
             }
            if (_nxmNxTunIpv4Dst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxTunIpv4Dst=");
                builder.append(_nxmNxTunIpv4Dst);
             }
            if (_nxmNxTunIpv4Src != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmNxTunIpv4Src=");
                builder.append(_nxmNxTunIpv4Src);
             }
            if (_nxmOfArpOp != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfArpOp=");
                builder.append(_nxmOfArpOp);
             }
            if (_nxmOfArpSpa != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfArpSpa=");
                builder.append(_nxmOfArpSpa);
             }
            if (_nxmOfArpTpa != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfArpTpa=");
                builder.append(_nxmOfArpTpa);
             }
            if (_nxmOfEthDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfEthDst=");
                builder.append(_nxmOfEthDst);
             }
            if (_nxmOfEthSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfEthSrc=");
                builder.append(_nxmOfEthSrc);
             }
            if (_nxmOfEthType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfEthType=");
                builder.append(_nxmOfEthType);
             }
            if (_nxmOfIcmpType != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfIcmpType=");
                builder.append(_nxmOfIcmpType);
             }
            if (_nxmOfIpDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfIpDst=");
                builder.append(_nxmOfIpDst);
             }
            if (_nxmOfIpSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfIpSrc=");
                builder.append(_nxmOfIpSrc);
             }
            if (_nxmOfTcpDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfTcpDst=");
                builder.append(_nxmOfTcpDst);
             }
            if (_nxmOfTcpSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfTcpSrc=");
                builder.append(_nxmOfTcpSrc);
             }
            if (_nxmOfUdpDst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfUdpDst=");
                builder.append(_nxmOfUdpDst);
             }
            if (_nxmOfUdpSrc != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_nxmOfUdpSrc=");
                builder.append(_nxmOfUdpSrc);
             }
            return builder.append(']').toString();
        }
    }

}
