package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionConntrackGrouping;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.Augmentable;


/**
 * <p>This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <br>(Source path: <i>META-INF/yang/openflowplugin-extension-nicira-action.yang</i>):
 * <pre>
 * container nx-conntrack {
 *     leaf flags {
 *         type uint16;
 *     }
 *     leaf zone-src {
 *         type uint32;
 *     }
 *     leaf conntrack-zone {
 *         type uint16;
 *     }
 *     leaf recirc-table {
 *         type uint8;
 *     }
 * }
 * </pre>
 * The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-action/nx-action-conntrack-grouping/nx-conntrack</i>
 *
 * <p>To create instances of this class use {@link org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrackBuilder}.
 * @see org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrackBuilder
 *
 */
public interface NxConntrack
    extends
    ChildOf<NxActionConntrackGrouping>,
    Augmentable<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.conntrack.grouping.NxConntrack>
{



    public static final QName QNAME = org.opendaylight.yangtools.yang.common.QName.create("urn:opendaylight:openflowplugin:extension:nicira:action",
        "2014-07-14", "nx-conntrack").intern();

    java.lang.Integer getFlags();
    
    java.lang.Long getZoneSrc();
    
    java.lang.Integer getConntrackZone();
    
    java.lang.Short getRecircTable();

}

