/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.nx.output.reg.Src;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.src.choice.grouping.SrcChoice;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class SrcBuilder
implements Builder<Src> {
    private Integer _ofsNbits;
    private SrcChoice _srcChoice;
    Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();

    public SrcBuilder() {
    }

    public SrcBuilder(SrcChoiceGrouping arg) {
        this._srcChoice = arg.getSrcChoice();
    }

    public SrcBuilder(Src base) {
        AugmentationHolder casted;
        this._ofsNbits = base.getOfsNbits();
        this._srcChoice = base.getSrcChoice();
        if (base instanceof SrcImpl) {
            SrcImpl impl = (SrcImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(casted.augmentations());
        }
    }

    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof SrcChoiceGrouping) {
            this._srcChoice = ((SrcChoiceGrouping)arg).getSrcChoice();
            isValidArg = true;
        }
        if (!isValidArg) {
            throw new IllegalArgumentException("expected one of: [org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.SrcChoiceGrouping] \nbut was: " + arg);
        }
    }

    public Integer getOfsNbits() {
        return this._ofsNbits;
    }

    public SrcChoice getSrcChoice() {
        return this._srcChoice;
    }

    public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    private static void checkOfsNbitsRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public SrcBuilder setOfsNbits(Integer value) {
        if (value != null) {
            SrcBuilder.checkOfsNbitsRange(value);
        }
        this._ofsNbits = value;
        return this;
    }

    public SrcBuilder setSrcChoice(SrcChoice value) {
        this._srcChoice = value;
        return this;
    }

    public SrcBuilder addAugmentation(Class<? extends Augmentation<Src>> augmentationType, Augmentation<Src> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public SrcBuilder removeAugmentation(Class<? extends Augmentation<Src>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public Src build() {
        return new SrcImpl(this);
    }

    private static final class SrcImpl
    implements Src {
        private final Integer _ofsNbits;
        private final SrcChoice _srcChoice;
        private Map<Class<? extends Augmentation<Src>>, Augmentation<Src>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<Src> getImplementedInterface() {
            return Src.class;
        }

        private SrcImpl(SrcBuilder base) {
            this._ofsNbits = base.getOfsNbits();
            this._srcChoice = base.getSrcChoice();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<Src>>, Augmentation<Src>>(base.augmentation);
                }
            }
        }

        @Override
        public Integer getOfsNbits() {
            return this._ofsNbits;
        }

        @Override
        public SrcChoice getSrcChoice() {
            return this._srcChoice;
        }

        public <E extends Augmentation<Src>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._ofsNbits);
            result = 31 * result + Objects.hashCode(this._srcChoice);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!Src.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            Src other = (Src)obj;
            if (!Objects.equals(this._ofsNbits, other.getOfsNbits())) {
                return false;
            }
            if (!Objects.equals(this._srcChoice, other.getSrcChoice())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                SrcImpl otherImpl = (SrcImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<Src>>, Augmentation<Src>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("Src [");
            boolean first = true;
            if (this._ofsNbits != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_ofsNbits=");
                builder.append(this._ofsNbits);
            }
            if (this._srcChoice != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_srcChoice=");
                builder.append(this._srcChoice);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

