/*
 * Decompiled with CFR 0.152.
 */
package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.AugmentationHolder;
import org.opendaylight.yangtools.yang.binding.DataObject;

public class NxMultipathBuilder
implements Builder<NxMultipath> {
    private OfjNxMpAlgorithm _algorithm;
    private Long _arg;
    private Integer _basis;
    private Dst _dst;
    private OfjNxHashFields _fields;
    private Integer _maxLink;
    Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();

    public NxMultipathBuilder() {
    }

    public NxMultipathBuilder(NxMultipath base) {
        AugmentationHolder casted;
        this._algorithm = base.getAlgorithm();
        this._arg = base.getArg();
        this._basis = base.getBasis();
        this._dst = base.getDst();
        this._fields = base.getFields();
        this._maxLink = base.getMaxLink();
        if (base instanceof NxMultipathImpl) {
            NxMultipathImpl impl = (NxMultipathImpl)base;
            if (!impl.augmentation.isEmpty()) {
                this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(impl.augmentation);
            }
        } else if (base instanceof AugmentationHolder && !(casted = (AugmentationHolder)base).augmentations().isEmpty()) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(casted.augmentations());
        }
    }

    public OfjNxMpAlgorithm getAlgorithm() {
        return this._algorithm;
    }

    public Long getArg() {
        return this._arg;
    }

    public Integer getBasis() {
        return this._basis;
    }

    public Dst getDst() {
        return this._dst;
    }

    public OfjNxHashFields getFields() {
        return this._fields;
    }

    public Integer getMaxLink() {
        return this._maxLink;
    }

    public <E extends Augmentation<NxMultipath>> E getAugmentation(Class<E> augmentationType) {
        if (augmentationType == null) {
            throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
        }
        return (E)this.augmentation.get(augmentationType);
    }

    public NxMultipathBuilder setAlgorithm(OfjNxMpAlgorithm value) {
        this._algorithm = value;
        return this;
    }

    private static void checkArgRange(long value) {
        if (value >= 0L && value <= 0xFFFFFFFFL) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u20254294967295]].", value));
    }

    public NxMultipathBuilder setArg(Long value) {
        if (value != null) {
            NxMultipathBuilder.checkArgRange(value);
        }
        this._arg = value;
        return this;
    }

    private static void checkBasisRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxMultipathBuilder setBasis(Integer value) {
        if (value != null) {
            NxMultipathBuilder.checkBasisRange(value);
        }
        this._basis = value;
        return this;
    }

    public NxMultipathBuilder setDst(Dst value) {
        this._dst = value;
        return this;
    }

    public NxMultipathBuilder setFields(OfjNxHashFields value) {
        this._fields = value;
        return this;
    }

    private static void checkMaxLinkRange(int value) {
        if (value >= 0 && value <= 65535) {
            return;
        }
        throw new IllegalArgumentException(String.format("Invalid range: %s, expected: [[0\u202565535]].", value));
    }

    public NxMultipathBuilder setMaxLink(Integer value) {
        if (value != null) {
            NxMultipathBuilder.checkMaxLinkRange(value);
        }
        this._maxLink = value;
        return this;
    }

    public NxMultipathBuilder addAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType, Augmentation<NxMultipath> augmentation) {
        if (augmentation == null) {
            return this.removeAugmentation(augmentationType);
        }
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>();
        }
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }

    public NxMultipathBuilder removeAugmentation(Class<? extends Augmentation<NxMultipath>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    public NxMultipath build() {
        return new NxMultipathImpl(this);
    }

    private static final class NxMultipathImpl
    implements NxMultipath {
        private final OfjNxMpAlgorithm _algorithm;
        private final Long _arg;
        private final Integer _basis;
        private final Dst _dst;
        private final OfjNxHashFields _fields;
        private final Integer _maxLink;
        private Map<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> augmentation = Collections.emptyMap();
        private int hash = 0;
        private volatile boolean hashValid = false;

        public Class<NxMultipath> getImplementedInterface() {
            return NxMultipath.class;
        }

        private NxMultipathImpl(NxMultipathBuilder base) {
            this._algorithm = base.getAlgorithm();
            this._arg = base.getArg();
            this._basis = base.getBasis();
            this._dst = base.getDst();
            this._fields = base.getFields();
            this._maxLink = base.getMaxLink();
            switch (base.augmentation.size()) {
                case 0: {
                    this.augmentation = Collections.emptyMap();
                    break;
                }
                case 1: {
                    Map.Entry<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> e = base.augmentation.entrySet().iterator().next();
                    this.augmentation = Collections.singletonMap(e.getKey(), e.getValue());
                    break;
                }
                default: {
                    this.augmentation = new HashMap<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>>(base.augmentation);
                }
            }
        }

        @Override
        public OfjNxMpAlgorithm getAlgorithm() {
            return this._algorithm;
        }

        @Override
        public Long getArg() {
            return this._arg;
        }

        @Override
        public Integer getBasis() {
            return this._basis;
        }

        @Override
        public Dst getDst() {
            return this._dst;
        }

        @Override
        public OfjNxHashFields getFields() {
            return this._fields;
        }

        @Override
        public Integer getMaxLink() {
            return this._maxLink;
        }

        public <E extends Augmentation<NxMultipath>> E getAugmentation(Class<E> augmentationType) {
            if (augmentationType == null) {
                throw new IllegalArgumentException("Augmentation Type reference cannot be NULL!");
            }
            return (E)this.augmentation.get(augmentationType);
        }

        public int hashCode() {
            if (this.hashValid) {
                return this.hash;
            }
            int prime = 31;
            int result = 1;
            result = 31 * result + Objects.hashCode(this._algorithm);
            result = 31 * result + Objects.hashCode(this._arg);
            result = 31 * result + Objects.hashCode(this._basis);
            result = 31 * result + Objects.hashCode(this._dst);
            result = 31 * result + Objects.hashCode(this._fields);
            result = 31 * result + Objects.hashCode(this._maxLink);
            this.hash = result = 31 * result + Objects.hashCode(this.augmentation);
            this.hashValid = true;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof DataObject)) {
                return false;
            }
            if (!NxMultipath.class.equals((Object)((DataObject)obj).getImplementedInterface())) {
                return false;
            }
            NxMultipath other = (NxMultipath)obj;
            if (!Objects.equals(this._algorithm, other.getAlgorithm())) {
                return false;
            }
            if (!Objects.equals(this._arg, other.getArg())) {
                return false;
            }
            if (!Objects.equals(this._basis, other.getBasis())) {
                return false;
            }
            if (!Objects.equals(this._dst, other.getDst())) {
                return false;
            }
            if (!Objects.equals(this._fields, other.getFields())) {
                return false;
            }
            if (!Objects.equals(this._maxLink, other.getMaxLink())) {
                return false;
            }
            if (this.getClass() == obj.getClass()) {
                NxMultipathImpl otherImpl = (NxMultipathImpl)obj;
                if (!Objects.equals(this.augmentation, otherImpl.augmentation)) {
                    return false;
                }
            } else {
                for (Map.Entry<Class<? extends Augmentation<NxMultipath>>, Augmentation<NxMultipath>> e : this.augmentation.entrySet()) {
                    if (e.getValue().equals((Object)other.getAugmentation(e.getKey()))) continue;
                    return false;
                }
                if (!obj.equals(this)) {
                    return false;
                }
            }
            return true;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder("NxMultipath [");
            boolean first = true;
            if (this._algorithm != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_algorithm=");
                builder.append(this._algorithm);
            }
            if (this._arg != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_arg=");
                builder.append(this._arg);
            }
            if (this._basis != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_basis=");
                builder.append(this._basis);
            }
            if (this._dst != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_dst=");
                builder.append(this._dst);
            }
            if (this._fields != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_fields=");
                builder.append(this._fields);
            }
            if (this._maxLink != null) {
                if (first) {
                    first = false;
                } else {
                    builder.append(", ");
                }
                builder.append("_maxLink=");
                builder.append(this._maxLink);
            }
            if (first) {
                first = false;
            } else {
                builder.append(", ");
            }
            builder.append("augmentation=");
            builder.append(this.augmentation.values());
            return builder.append(']').toString();
        }
    }
}

