package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.updated.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionCtClearGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.ct.clear.grouping.NxCtClear;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder implements Builder<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase> {

    private NxCtClear _nxCtClear;


    Map<Class<? extends Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder() {
    }
    
    
    
    
    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder(NxActionCtClearGrouping arg) {
        this._nxCtClear = arg.getNxCtClear();
    }

    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder(NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase base) {
        Map<Class<? extends Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>>, Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxCtClear = base.getNxCtClear();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxActionCtClearGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxActionCtClearGrouping) {
            this._nxCtClear = ((NxActionCtClearGrouping)arg).getNxCtClear();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxActionCtClearGrouping]");
    }

    public NxCtClear getNxCtClear() {
        return _nxCtClear;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder setNxCtClear(final NxCtClear value) {
        this._nxCtClear = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder addAugmentation(Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase> augmentation) {
        Class<? extends Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase build() {
        return new NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseImpl(this);
    }

    private static final class NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase>
        implements NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase {
    
        private final NxCtClear _nxCtClear;
    
        NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseImpl(NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxCtClear = base.getNxCtClear();
        }
    
        @Override
        public NxCtClear getNxCtClear() {
            return _nxCtClear;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionCtClearRpcUpdateFlowUpdatedWriteActionsCase.bindingToString(this);
        }
    }
}
