package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.remove.flow.input.instructions.instruction.instruction.apply.actions._case.apply.actions.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionOutputRegGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.output.reg.grouping.NxOutputReg;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder implements Builder<NxActionOutputRegRpcRemoveFlowApplyActionsCase> {

    private NxOutputReg _nxOutputReg;


    Map<Class<? extends Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>> augmentation = Collections.emptyMap();

    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder() {
    }
    
    
    
    
    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder(NxActionOutputRegGrouping arg) {
        this._nxOutputReg = arg.getNxOutputReg();
    }

    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder(NxActionOutputRegRpcRemoveFlowApplyActionsCase base) {
        Map<Class<? extends Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>>, Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxOutputReg = base.getNxOutputReg();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>NxActionOutputRegGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof NxActionOutputRegGrouping) {
            this._nxOutputReg = ((NxActionOutputRegGrouping)arg).getNxOutputReg();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[NxActionOutputRegGrouping]");
    }

    public NxOutputReg getNxOutputReg() {
        return _nxOutputReg;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder setNxOutputReg(final NxOutputReg value) {
        this._nxOutputReg = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder addAugmentation(Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase> augmentation) {
        Class<? extends Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionOutputRegRpcRemoveFlowApplyActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionOutputRegRpcRemoveFlowApplyActionsCase build() {
        return new NxActionOutputRegRpcRemoveFlowApplyActionsCaseImpl(this);
    }

    private static final class NxActionOutputRegRpcRemoveFlowApplyActionsCaseImpl
        extends AbstractAugmentable<NxActionOutputRegRpcRemoveFlowApplyActionsCase>
        implements NxActionOutputRegRpcRemoveFlowApplyActionsCase {
    
        private final NxOutputReg _nxOutputReg;
    
        NxActionOutputRegRpcRemoveFlowApplyActionsCaseImpl(NxActionOutputRegRpcRemoveFlowApplyActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxOutputReg = base.getNxOutputReg();
        }
    
        @Override
        public NxOutputReg getNxOutputReg() {
            return _nxOutputReg;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionOutputRegRpcRemoveFlowApplyActionsCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionOutputRegRpcRemoveFlowApplyActionsCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionOutputRegRpcRemoveFlowApplyActionsCase.bindingToString(this);
        }
    }
}
