package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxHashFields;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.action.rev140421.OfjNxMpAlgorithm;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionMultipathGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.nx.multipath.Dst;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-multipath {
 *   leaf fields {
 *     type nicira-action:ofj-nx-hash-fields;
 *   }
 *   leaf basis {
 *     type uint16;
 *     default 0x400;
 *   }
 *   leaf algorithm {
 *     type nicira-action:ofj-nx-mp-algorithm;
 *   }
 *   leaf max-link {
 *     type uint16;
 *   }
 *   leaf arg {
 *     type uint32;
 *   }
 *   container dst {
 *     uses dst-choice-grouping;
 *     uses range-grouping;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-actionnx-action-multipath-groupingnx-multipath</i>
 *
 * <p>To create instances of this class use {@link NxMultipathBuilder}.
 * @see NxMultipathBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxMultipath
    extends
    ChildOf<NxActionMultipathGrouping>,
    Augmentable<NxMultipath>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-multipath");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.@NonNull NxMultipath obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getAlgorithm());
        result = prime * result + Objects.hashCode(obj.getArg());
        result = prime * result + Objects.hashCode(obj.getBasis());
        result = prime * result + Objects.hashCode(obj.getDst());
        result = prime * result + Objects.hashCode(obj.getFields());
        result = prime * result + Objects.hashCode(obj.getMaxLink());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.@NonNull NxMultipath thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.NxMultipath.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getArg(), other.getArg())) {
            return false;
        }
        if (!Objects.equals(thisObj.getBasis(), other.getBasis())) {
            return false;
        }
        if (!Objects.equals(thisObj.getMaxLink(), other.getMaxLink())) {
            return false;
        }
        if (!Objects.equals(thisObj.getAlgorithm(), other.getAlgorithm())) {
            return false;
        }
        if (!Objects.equals(thisObj.getDst(), other.getDst())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFields(), other.getFields())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.multipath.grouping.@NonNull NxMultipath obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxMultipath");
        CodeHelpers.appendValue(helper, "algorithm", obj.getAlgorithm());
        CodeHelpers.appendValue(helper, "arg", obj.getArg());
        CodeHelpers.appendValue(helper, "basis", obj.getBasis());
        CodeHelpers.appendValue(helper, "dst", obj.getDst());
        CodeHelpers.appendValue(helper, "fields", obj.getFields());
        CodeHelpers.appendValue(helper, "maxLink", obj.getMaxLink());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return fields, or {@code null} if it is not present.
     *
     * @return {@code OfjNxHashFields} fields, or {@code null} if it is not present.
     *
     */
    OfjNxHashFields getFields();
    
    /**
     * Return fields, guaranteed to be non-null.
     *
     * @return {@code OfjNxHashFields} fields, guaranteed to be non-null.
     * @throws NoSuchElementException if fields is not present
     *
     */
    default @NonNull OfjNxHashFields requireFields() {
        return CodeHelpers.require(getFields(), "fields");
    }
    
    /**
     * Return basis, or {@code null} if it is not present.
     *
     * @return {@code Uint16} basis, or {@code null} if it is not present.
     *
     */
    Uint16 getBasis();
    
    /**
     * Return basis, guaranteed to be non-null.
     *
     * @return {@code Uint16} basis, guaranteed to be non-null.
     * @throws NoSuchElementException if basis is not present
     *
     */
    default @NonNull Uint16 requireBasis() {
        return CodeHelpers.require(getBasis(), "basis");
    }
    
    /**
     * Return algorithm, or {@code null} if it is not present.
     *
     * @return {@code OfjNxMpAlgorithm} algorithm, or {@code null} if it is not present.
     *
     */
    OfjNxMpAlgorithm getAlgorithm();
    
    /**
     * Return algorithm, guaranteed to be non-null.
     *
     * @return {@code OfjNxMpAlgorithm} algorithm, guaranteed to be non-null.
     * @throws NoSuchElementException if algorithm is not present
     *
     */
    default @NonNull OfjNxMpAlgorithm requireAlgorithm() {
        return CodeHelpers.require(getAlgorithm(), "algorithm");
    }
    
    /**
     * Return maxLink, or {@code null} if it is not present.
     *
     * @return {@code Uint16} maxLink, or {@code null} if it is not present.
     *
     */
    Uint16 getMaxLink();
    
    /**
     * Return maxLink, guaranteed to be non-null.
     *
     * @return {@code Uint16} maxLink, guaranteed to be non-null.
     * @throws NoSuchElementException if maxLink is not present
     *
     */
    default @NonNull Uint16 requireMaxLink() {
        return CodeHelpers.require(getMaxLink(), "maxlink");
    }
    
    /**
     * Return arg, or {@code null} if it is not present.
     *
     * @return {@code Uint32} arg, or {@code null} if it is not present.
     *
     */
    Uint32 getArg();
    
    /**
     * Return arg, guaranteed to be non-null.
     *
     * @return {@code Uint32} arg, guaranteed to be non-null.
     * @throws NoSuchElementException if arg is not present
     *
     */
    default @NonNull Uint32 requireArg() {
        return CodeHelpers.require(getArg(), "arg");
    }
    
    /**
     * Return dst, or {@code null} if it is not present.
     *
     * <pre>
     *     <code>
     *         Writes value to bits start through end, inclusive, in field dst.
     *     </code>
     * </pre>
     *
     * @return {@code Dst} dst, or {@code null} if it is not present.
     *
     */
    Dst getDst();

}

