package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionLearnGrouping;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.nx.learn.FlowMods;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint64;
import org.opendaylight.yangtools.yang.common.Uint8;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-learn {
 *   leaf idle-timeout {
 *     type uint16;
 *   }
 *   leaf hard-timeout {
 *     type uint16;
 *   }
 *   leaf priority {
 *     type uint16;
 *   }
 *   leaf cookie {
 *     type uint64;
 *   }
 *   leaf flags {
 *     type uint16;
 *   }
 *   leaf table-id {
 *     type uint8;
 *   }
 *   leaf fin-idle-timeout {
 *     type uint16;
 *   }
 *   leaf fin-hard-timeout {
 *     type uint16;
 *   }
 *   list flow-mods {
 *     uses flow-mod-spec;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-actionnx-action-learn-groupingnx-learn</i>
 *
 * <p>To create instances of this class use {@link NxLearnBuilder}.
 * @see NxLearnBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxLearn
    extends
    ChildOf<NxActionLearnGrouping>,
    Augmentable<NxLearn>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-learn");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.@NonNull NxLearn obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getCookie());
        result = prime * result + Objects.hashCode(obj.getFinHardTimeout());
        result = prime * result + Objects.hashCode(obj.getFinIdleTimeout());
        result = prime * result + Objects.hashCode(obj.getFlags());
        result = prime * result + Objects.hashCode(obj.getFlowMods());
        result = prime * result + Objects.hashCode(obj.getHardTimeout());
        result = prime * result + Objects.hashCode(obj.getIdleTimeout());
        result = prime * result + Objects.hashCode(obj.getPriority());
        result = prime * result + Objects.hashCode(obj.getTableId());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.@NonNull NxLearn thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.NxLearn.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getCookie(), other.getCookie())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFinHardTimeout(), other.getFinHardTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFinIdleTimeout(), other.getFinIdleTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFlags(), other.getFlags())) {
            return false;
        }
        if (!Objects.equals(thisObj.getHardTimeout(), other.getHardTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getIdleTimeout(), other.getIdleTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getPriority(), other.getPriority())) {
            return false;
        }
        if (!Objects.equals(thisObj.getTableId(), other.getTableId())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFlowMods(), other.getFlowMods())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.learn.grouping.@NonNull NxLearn obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxLearn");
        CodeHelpers.appendValue(helper, "cookie", obj.getCookie());
        CodeHelpers.appendValue(helper, "finHardTimeout", obj.getFinHardTimeout());
        CodeHelpers.appendValue(helper, "finIdleTimeout", obj.getFinIdleTimeout());
        CodeHelpers.appendValue(helper, "flags", obj.getFlags());
        CodeHelpers.appendValue(helper, "flowMods", obj.getFlowMods());
        CodeHelpers.appendValue(helper, "hardTimeout", obj.getHardTimeout());
        CodeHelpers.appendValue(helper, "idleTimeout", obj.getIdleTimeout());
        CodeHelpers.appendValue(helper, "priority", obj.getPriority());
        CodeHelpers.appendValue(helper, "tableId", obj.getTableId());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return idleTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} idleTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getIdleTimeout();
    
    /**
     * Return idleTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} idleTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if idleTimeout is not present
     *
     */
    default @NonNull Uint16 requireIdleTimeout() {
        return CodeHelpers.require(getIdleTimeout(), "idletimeout");
    }
    
    /**
     * Return hardTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} hardTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getHardTimeout();
    
    /**
     * Return hardTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} hardTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if hardTimeout is not present
     *
     */
    default @NonNull Uint16 requireHardTimeout() {
        return CodeHelpers.require(getHardTimeout(), "hardtimeout");
    }
    
    /**
     * Return priority, or {@code null} if it is not present.
     *
     * @return {@code Uint16} priority, or {@code null} if it is not present.
     *
     */
    Uint16 getPriority();
    
    /**
     * Return priority, guaranteed to be non-null.
     *
     * @return {@code Uint16} priority, guaranteed to be non-null.
     * @throws NoSuchElementException if priority is not present
     *
     */
    default @NonNull Uint16 requirePriority() {
        return CodeHelpers.require(getPriority(), "priority");
    }
    
    /**
     * Return cookie, or {@code null} if it is not present.
     *
     * @return {@code Uint64} cookie, or {@code null} if it is not present.
     *
     */
    Uint64 getCookie();
    
    /**
     * Return cookie, guaranteed to be non-null.
     *
     * @return {@code Uint64} cookie, guaranteed to be non-null.
     * @throws NoSuchElementException if cookie is not present
     *
     */
    default @NonNull Uint64 requireCookie() {
        return CodeHelpers.require(getCookie(), "cookie");
    }
    
    /**
     * Return flags, or {@code null} if it is not present.
     *
     * @return {@code Uint16} flags, or {@code null} if it is not present.
     *
     */
    Uint16 getFlags();
    
    /**
     * Return flags, guaranteed to be non-null.
     *
     * @return {@code Uint16} flags, guaranteed to be non-null.
     * @throws NoSuchElementException if flags is not present
     *
     */
    default @NonNull Uint16 requireFlags() {
        return CodeHelpers.require(getFlags(), "flags");
    }
    
    /**
     * Return tableId, or {@code null} if it is not present.
     *
     * @return {@code Uint8} tableId, or {@code null} if it is not present.
     *
     */
    Uint8 getTableId();
    
    /**
     * Return tableId, guaranteed to be non-null.
     *
     * @return {@code Uint8} tableId, guaranteed to be non-null.
     * @throws NoSuchElementException if tableId is not present
     *
     */
    default @NonNull Uint8 requireTableId() {
        return CodeHelpers.require(getTableId(), "tableid");
    }
    
    /**
     * Return finIdleTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} finIdleTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getFinIdleTimeout();
    
    /**
     * Return finIdleTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} finIdleTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if finIdleTimeout is not present
     *
     */
    default @NonNull Uint16 requireFinIdleTimeout() {
        return CodeHelpers.require(getFinIdleTimeout(), "finidletimeout");
    }
    
    /**
     * Return finHardTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} finHardTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getFinHardTimeout();
    
    /**
     * Return finHardTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} finHardTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if finHardTimeout is not present
     *
     */
    default @NonNull Uint16 requireFinHardTimeout() {
        return CodeHelpers.require(getFinHardTimeout(), "finhardtimeout");
    }
    
    /**
     * Return flowMods, or {@code null} if it is not present.
     *
     * @return {@code List<FlowMods>} flowMods, or {@code null} if it is not present.
     *
     */
    @Nullable List<FlowMods> getFlowMods();
    
    /**
     * Return flowMods, or an empty list if it is not present.
     *
     * @return {@code List<FlowMods>} flowMods, or an empty list if it is not present.
     *
     */
    default @NonNull List<FlowMods> nonnullFlowMods() {
        return CodeHelpers.nonnull(getFlowMods());
    }

}

