package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.NoSuchElementException;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionFinTimeoutGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint16;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-action</b>
 * <pre>
 * container nx-action-fin-timeout {
 *   leaf fin-idle-timeout {
 *     type uint16;
 *   }
 *   leaf fin-hard-timeout {
 *     type uint16;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-actionnx-action-fin-timeout-groupingnx-action-fin-timeout</i>
 *
 * <p>To create instances of this class use {@link NxActionFinTimeoutBuilder}.
 * @see NxActionFinTimeoutBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxActionFinTimeout
    extends
    ChildOf<NxActionFinTimeoutGrouping>,
    Augmentable<NxActionFinTimeout>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nx-action-fin-timeout");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.@NonNull NxActionFinTimeout obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getFinHardTimeout());
        result = prime * result + Objects.hashCode(obj.getFinIdleTimeout());
        for (var augmentation : obj.augmentations().values()) {
            result += augmentation.hashCode();
        }
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.@NonNull NxActionFinTimeout thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.NxActionFinTimeout.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getFinHardTimeout(), other.getFinHardTimeout())) {
            return false;
        }
        if (!Objects.equals(thisObj.getFinIdleTimeout(), other.getFinIdleTimeout())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.fin.timeout.grouping.@NonNull NxActionFinTimeout obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxActionFinTimeout");
        CodeHelpers.appendValue(helper, "finHardTimeout", obj.getFinHardTimeout());
        CodeHelpers.appendValue(helper, "finIdleTimeout", obj.getFinIdleTimeout());
        CodeHelpers.appendAugmentations(helper, "augmentation", obj);
        return helper.toString();
    }
    
    /**
     * Return finIdleTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} finIdleTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getFinIdleTimeout();
    
    /**
     * Return finIdleTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} finIdleTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if finIdleTimeout is not present
     *
     */
    default @NonNull Uint16 requireFinIdleTimeout() {
        return CodeHelpers.require(getFinIdleTimeout(), "finidletimeout");
    }
    
    /**
     * Return finHardTimeout, or {@code null} if it is not present.
     *
     * @return {@code Uint16} finHardTimeout, or {@code null} if it is not present.
     *
     */
    Uint16 getFinHardTimeout();
    
    /**
     * Return finHardTimeout, guaranteed to be non-null.
     *
     * @return {@code Uint16} finHardTimeout, guaranteed to be non-null.
     * @throws NoSuchElementException if finHardTimeout is not present
     *
     */
    default @NonNull Uint16 requireFinHardTimeout() {
        return CodeHelpers.require(getFinHardTimeout(), "finhardtimeout");
    }

}

