package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.flow.mod.spec.flow.mod.spec.flow.mod.copy.value.into.field._case;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.common.Uint16;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 * Class that builds {@link FlowModCopyValueIntoFieldBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     FlowModCopyValueIntoFieldBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new FlowModCopyValueIntoFieldBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of FlowModCopyValueIntoFieldBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see FlowModCopyValueIntoFieldBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class FlowModCopyValueIntoFieldBuilder implements Builder<FlowModCopyValueIntoField> {

    private Uint32 _dstField;
    private Uint16 _dstOfs;
    private Uint16 _flowModNumBits;
    private Uint16 _value;


    Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> augmentation = Collections.emptyMap();

    public FlowModCopyValueIntoFieldBuilder() {
    }
    
    

    public FlowModCopyValueIntoFieldBuilder(FlowModCopyValueIntoField base) {
        Map<Class<? extends Augmentation<FlowModCopyValueIntoField>>, Augmentation<FlowModCopyValueIntoField>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._dstField = base.getDstField();
        this._dstOfs = base.getDstOfs();
        this._flowModNumBits = base.getFlowModNumBits();
        this._value = base.getValue();
    }


    public Uint32 getDstField() {
        return _dstField;
    }
    
    public Uint16 getDstOfs() {
        return _dstOfs;
    }
    
    public Uint16 getFlowModNumBits() {
        return _flowModNumBits;
    }
    
    public Uint16 getValue() {
        return _value;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<FlowModCopyValueIntoField>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public FlowModCopyValueIntoFieldBuilder setDstField(final Uint32 value) {
        this._dstField = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder setDstOfs(final Uint16 value) {
        this._dstOfs = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder setFlowModNumBits(final Uint16 value) {
        this._flowModNumBits = value;
        return this;
    }
    
    public FlowModCopyValueIntoFieldBuilder setValue(final Uint16 value) {
        this._value = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public FlowModCopyValueIntoFieldBuilder addAugmentation(Augmentation<FlowModCopyValueIntoField> augmentation) {
        Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public FlowModCopyValueIntoFieldBuilder removeAugmentation(Class<? extends Augmentation<FlowModCopyValueIntoField>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public FlowModCopyValueIntoField build() {
        return new FlowModCopyValueIntoFieldImpl(this);
    }

    private static final class FlowModCopyValueIntoFieldImpl
        extends AbstractAugmentable<FlowModCopyValueIntoField>
        implements FlowModCopyValueIntoField {
    
        private final Uint32 _dstField;
        private final Uint16 _dstOfs;
        private final Uint16 _flowModNumBits;
        private final Uint16 _value;
    
        FlowModCopyValueIntoFieldImpl(FlowModCopyValueIntoFieldBuilder base) {
            super(base.augmentation);
            this._dstField = base.getDstField();
            this._dstOfs = base.getDstOfs();
            this._flowModNumBits = base.getFlowModNumBits();
            this._value = base.getValue();
        }
    
        @Override
        public Uint32 getDstField() {
            return _dstField;
        }
        
        @Override
        public Uint16 getDstOfs() {
            return _dstOfs;
        }
        
        @Override
        public Uint16 getFlowModNumBits() {
            return _flowModNumBits;
        }
        
        @Override
        public Uint16 getValue() {
            return _value;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = FlowModCopyValueIntoField.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return FlowModCopyValueIntoField.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return FlowModCopyValueIntoField.bindingToString(this);
        }
    }
}
