package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nodes.node.table.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.reg.move.grouping.NxRegMove;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder implements Builder<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> {

    private NxRegMove _nxRegMove;


    Map<Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder() {
    }
    
    
    
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping arg) {
        this._nxRegMove = arg.getNxRegMove();
    }
    

    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder(NxActionRegMoveNodesNodeTableFlowWriteActionsCase base) {
        Map<Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>>, Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxRegMove = base.getNxRegMove();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping) {
            this._nxRegMove = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping)arg).getNxRegMove();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionRegMoveGrouping]");
    }

    public NxRegMove getNxRegMove() {
        return _nxRegMove;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder setNxRegMove(final NxRegMove value) {
        this._nxRegMove = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder addAugmentation(Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase> augmentation) {
        Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionRegMoveNodesNodeTableFlowWriteActionsCase build() {
        return new NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl(this);
    }

    private static final class NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionRegMoveNodesNodeTableFlowWriteActionsCase>
        implements NxActionRegMoveNodesNodeTableFlowWriteActionsCase {
    
        private final NxRegMove _nxRegMove;
    
        NxActionRegMoveNodesNodeTableFlowWriteActionsCaseImpl(NxActionRegMoveNodesNodeTableFlowWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxRegMove = base.getNxRegMove();
        }
    
        @Override
        public NxRegMove getNxRegMove() {
            return _nxRegMove;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionRegMoveNodesNodeTableFlowWriteActionsCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionRegMoveNodesNodeTableFlowWriteActionsCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionRegMoveNodesNodeTableFlowWriteActionsCase.bindingToString(this);
        }
    }
}
