package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping;
import com.google.common.base.MoreObjects;
import java.lang.Class;
import java.lang.NullPointerException;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.eclipse.jdt.annotation.NonNull;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.$YangModuleInfoImpl;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.NxmNxRegGrouping;
import org.opendaylight.yangtools.yang.binding.Augmentable;
import org.opendaylight.yangtools.yang.binding.ChildOf;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.common.QName;
import org.opendaylight.yangtools.yang.common.Uint32;

/**
 *
 * <p>
 * This class represents the following YANG schema fragment defined in module <b>openflowplugin-extension-nicira-match</b>
 * <pre>
 * container nxm-nx-reg {
 *   leaf reg {
 *     type identityref {
 *       base nxm-nx-reg;
 *     }
 *   }
 *   leaf value {
 *     type uint32;
 *   }
 *   leaf mask {
 *     type uint32;
 *   }
 * }
 * </pre>The schema path to identify an instance is
 * <i>openflowplugin-extension-nicira-match/nxm-nx-reg-grouping/nxm-nx-reg</i>
 *
 * <p>To create instances of this class use {@link NxmNxRegBuilder}.
 * @see NxmNxRegBuilder
 *
 */
@Generated("mdsal-binding-generator")
public interface NxmNxReg
    extends
    ChildOf<NxmNxRegGrouping>,
    Augmentable<NxmNxReg>
{



    public static final @NonNull QName QNAME = $YangModuleInfoImpl.qnameOf("nxm-nx-reg");

    @Override
    default Class<org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg> implementedInterface() {
        return org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg.class;
    }
    
    /**
     * Default implementation of {@link Object#hashCode()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent hashing
     * results across all implementations.
     *
     * @param obj Object for which to generate hashCode() result.
     * @return Hash code value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static int bindingHashCode(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.@NonNull NxmNxReg obj) {
        final int prime = 31;
        int result = 1;
        result = prime * result + Objects.hashCode(obj.getMask());
        result = prime * result + Objects.hashCode(obj.getReg());
        result = prime * result + Objects.hashCode(obj.getValue());
        result = prime * result + obj.augmentations().hashCode();
        return result;
    }
    
    /**
     * Default implementation of {@link Object#equals(Object)} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent equality
     * results across all implementations.
     *
     * @param thisObj Object acting as the receiver of equals invocation
     * @param obj Object acting as argument to equals invocation
     * @return True if thisObj and obj are considered equal
     * @throws NullPointerException if {@code thisObj} is null
     */
    static boolean bindingEquals(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.@NonNull NxmNxReg thisObj, final Object obj) {
        if (thisObj == obj) {
            return true;
        }
        final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg other = CodeHelpers.checkCast(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.NxmNxReg.class, obj);
        if (other == null) {
            return false;
        }
        if (!Objects.equals(thisObj.getMask(), other.getMask())) {
            return false;
        }
        if (!Objects.equals(thisObj.getReg(), other.getReg())) {
            return false;
        }
        if (!Objects.equals(thisObj.getValue(), other.getValue())) {
            return false;
        }
        return thisObj.augmentations().equals(other.augmentations());
    }
    
    /**
     * Default implementation of {@link Object#toString()} contract for this interface.
     * Implementations of this interface are encouraged to defer to this method to get consistent string
     * representations across all implementations.
     *
     * @param obj Object for which to generate toString() result.
     * @return {@link String} value of data modeled by this interface.
     * @throws NullPointerException if {@code obj} is null
     */
    static String bindingToString(final org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.match.rev140714.nxm.nx.reg.grouping.@NonNull NxmNxReg obj) {
        final MoreObjects.ToStringHelper helper = MoreObjects.toStringHelper("NxmNxReg");
        CodeHelpers.appendValue(helper, "mask", obj.getMask());
        CodeHelpers.appendValue(helper, "reg", obj.getReg());
        CodeHelpers.appendValue(helper, "value", obj.getValue());
        CodeHelpers.appendValue(helper, "augmentation", obj.augmentations().values());
        return helper.toString();
    }
    
    /**
     * Return reg, or {@code null} if it is not present.
     *
     * @return {@code java.lang.Class} reg, or {@code null} if it is not present.
     *
     */
    Class<? extends org.opendaylight.yang.gen.v1.urn.opendaylight.openflowjava.nx.match.rev140421.NxmNxReg> getReg();
    
    /**
     * Return value, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} value, or {@code null} if it is not present.
     *
     */
    Uint32 getValue();
    
    /**
     * Return mask, or {@code null} if it is not present.
     *
     * @return {@code org.opendaylight.yangtools.yang.common.Uint32} mask, or {@code null} if it is not present.
     *
     */
    Uint32 getMask();

}

