package org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.update.flow.input.original.flow.instructions.instruction.instruction.write.actions._case.write.actions.action.action;
import java.lang.Class;
import java.lang.Object;
import java.lang.Override;
import java.lang.String;
import java.lang.SuppressWarnings;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.processing.Generated;
import org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.nx.action.encap.grouping.NxEncap;
import org.opendaylight.yangtools.concepts.Builder;
import org.opendaylight.yangtools.yang.binding.AbstractAugmentable;
import org.opendaylight.yangtools.yang.binding.Augmentation;
import org.opendaylight.yangtools.yang.binding.CodeHelpers;
import org.opendaylight.yangtools.yang.binding.DataObject;

/**
 * Class that builds {@link NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder} instances. Overall design of the class is that of a
 * <a href="https://en.wikipedia.org/wiki/Fluent_interface">fluent interface</a>, where method chaining is used.
 *
 * <p>
 * In general, this class is supposed to be used like this template:
 * <pre>
 *   <code>
 *     NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder createTarget(int fooXyzzy, int barBaz) {
 *         return new NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilderBuilder()
 *             .setFoo(new FooBuilder().setXyzzy(fooXyzzy).build())
 *             .setBar(new BarBuilder().setBaz(barBaz).build())
 *             .build();
 *     }
 *   </code>
 * </pre>
 *
 * <p>
 * This pattern is supported by the immutable nature of NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder, as instances can be freely passed around without
 * worrying about synchronization issues.
 *
 * <p>
 * As a side note: method chaining results in:
 * <ul>
 *   <li>very efficient Java bytecode, as the method invocation result, in this case the Builder reference, is
 *       on the stack, so further method invocations just need to fill method arguments for the next method
 *       invocation, which is terminated by {@link #build()}, which is then returned from the method</li>
 *   <li>better understanding by humans, as the scope of mutable state (the builder) is kept to a minimum and is
 *       very localized</li>
 *   <li>better optimization oportunities, as the object scope is minimized in terms of invocation (rather than
 *       method) stack, making <a href="https://en.wikipedia.org/wiki/Escape_analysis">escape analysis</a> a lot
 *       easier. Given enough compiler (JIT/AOT) prowess, the cost of th builder object can be completely
 *       eliminated</li>
 * </ul>
 *
 * @see NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder
 * @see Builder
 *
 */
@Generated("mdsal-binding-generator")
public class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder implements Builder<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> {

    private NxEncap _nxEncap;


    Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentation = Collections.emptyMap();

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder() {
    }
    
    
    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping arg) {
        this._nxEncap = arg.getNxEncap();
    }
    

    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder(NxActionEncapRpcUpdateFlowOriginalWriteActionsCase base) {
        Map<Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>>, Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> aug = base.augmentations();
        if (!aug.isEmpty()) {
            this.augmentation = new HashMap<>(aug);
        }
        this._nxEncap = base.getNxEncap();
    }

    /**
     * Set fields from given grouping argument. Valid argument is instance of one of following types:
     * <ul>
     * <li>org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping</li>
     * </ul>
     *
     * @param arg grouping object
     * @throws IllegalArgumentException if given argument is none of valid types or has property with incompatible value
    */
    public void fieldsFrom(DataObject arg) {
        boolean isValidArg = false;
        if (arg instanceof org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping) {
            this._nxEncap = ((org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping)arg).getNxEncap();
            isValidArg = true;
        }
        CodeHelpers.validValue(isValidArg, arg, "[org.opendaylight.yang.gen.v1.urn.opendaylight.openflowplugin.extension.nicira.action.rev140714.NxActionEncapGrouping]");
    }

    public NxEncap getNxEncap() {
        return _nxEncap;
    }

    @SuppressWarnings({ "unchecked", "checkstyle:methodTypeParameterName"})
    public <E$$ extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> E$$ augmentation(Class<E$$> augmentationType) {
        return (E$$) augmentation.get(Objects.requireNonNull(augmentationType));
    }

    
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder setNxEncap(final NxEncap value) {
        this._nxEncap = value;
        return this;
    }
    
    /**
      * Add an augmentation to this builder's product.
      *
      * @param augmentation augmentation to be added
      * @return this builder
      * @throws NullPointerException if {@code augmentation} is null
      */
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder addAugmentation(Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase> augmentation) {
        Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType = augmentation.implementedInterface();
        if (!(this.augmentation instanceof HashMap)) {
            this.augmentation = new HashMap<>();
        }
    
        this.augmentation.put(augmentationType, augmentation);
        return this;
    }
    
    /**
      * Remove an augmentation from this builder's product. If this builder does not track such an augmentation
      * type, this method does nothing.
      *
      * @param augmentationType augmentation type to be removed
      * @return this builder
      */
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder removeAugmentation(Class<? extends Augmentation<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>> augmentationType) {
        if (this.augmentation instanceof HashMap) {
            this.augmentation.remove(augmentationType);
        }
        return this;
    }

    @Override
    public NxActionEncapRpcUpdateFlowOriginalWriteActionsCase build() {
        return new NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(this);
    }

    private static final class NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl
        extends AbstractAugmentable<NxActionEncapRpcUpdateFlowOriginalWriteActionsCase>
        implements NxActionEncapRpcUpdateFlowOriginalWriteActionsCase {
    
        private final NxEncap _nxEncap;
    
        NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseImpl(NxActionEncapRpcUpdateFlowOriginalWriteActionsCaseBuilder base) {
            super(base.augmentation);
            this._nxEncap = base.getNxEncap();
        }
    
        @Override
        public NxEncap getNxEncap() {
            return _nxEncap;
        }
    
        private int hash = 0;
        private volatile boolean hashValid = false;
        
        @Override
        public int hashCode() {
            if (hashValid) {
                return hash;
            }
        
            final int result = NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.bindingHashCode(this);
            hash = result;
            hashValid = true;
            return result;
        }
    
        @Override
        public boolean equals(Object obj) {
            return NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.bindingEquals(this, obj);
        }
    
        @Override
        public String toString() {
            return NxActionEncapRpcUpdateFlowOriginalWriteActionsCase.bindingToString(this);
        }
    }
}
